
#ifndef DIALOG_H
#define DIALOG_H


void do_dialog(char *buf)
{
	int a,i,f_height,f_width,height,width,done=0,x,y;
	BITMAP *tmp,*behind;
	char txt[15][256],*token,dems[]="~\t\n\f\x00D\x00A",*f,t[256];


	// copy our text to a temp var
	strcpy(t,buf);


	// the height of our font
	f_height=text_height(font);
	f_width=0;

	// a is the amount of lines
	a=0;

	// the buffer text is in one 256 character line. We need to split it up to 
	// the proper size.

	// grab the first line seperated by the ~ this should be the x coordinate
	token=strtok(t,dems);
	x=strtol(token,&f,0);
	
	// the y coordinate
	token=strtok(NULL,dems);
	y=strtol(token,&f,0);


	//seperate each token with the delimeters. 
	// basically everything that is seperated by the ~
	token=strtok(NULL,dems);

	while (token!=NULL)
	{
		strcpy(txt[a],token);
	
		if (f_width<text_length(font,txt[a]))
			f_width=text_length(font,txt[a]);
		
		// get the next line		
		token=strtok(NULL,dems);

		// increase a by one
		a++;		
	}


	// height and width of our box
	height=a*f_height+20;
	width=f_width+20;


	// two bitmaps, the box and what's underneath the box.
	tmp=create_bitmap(width,height);
	behind=create_bitmap(width,height);

	// we don't want to draw the corners so the tmp is treated as a sprite
	clear_to_color(tmp,0);
	text_mode(-1);

	// draw a rectangle and fill it with out color purple
	drawRectangle(tmp,0,0,width,height,255,2,5);

	// draw the text with a black shadow behind it.
	for (i=0; i<a; i++)
	{
		textout_centre(tmp,font,txt[i],11+f_width/2,11+i*f_height,224);
		textout_centre(tmp,font,txt[i],10+f_width/2,10+i*f_height,255);
	}

	// if the supplied values were negative then center the box
	if (x<0) x=SCREEN_W/2-width/2;
	if (y<0) y=SCREEN_H/2-height/2;


	blit(buffer,behind,x,y,0,0,width,height);
	draw_sprite(buffer,tmp,x,y);
	blitBuffer(buffer);
	blit(behind,buffer,0,0,x,y,width,height);	

	clear_keybuf();

	// wait until key pressed or mouse button pushed
	while (!done)
	{
		if (keypressed())
		{
			readkey();
			done=1;
		}
		if (mouse_b & 1)
		{
			while (mouse_b & 1) {}
			done=1;
		}
	}

	destroy_bitmap(tmp);
	destroy_bitmap(behind);
}


void do_dialog(DATAFILE *d,unsigned short begin,unsigned short end)
{
	int i;

	// this function does a series of dialogs. Intended to be a conversation
	// helper

	for (i=begin; i<=end; i++)
	{
		do_dialog((char*)d[i].dat);
	}
}



/*

#pragma warning( disable: 4311 )
#pragma warning( disable: 4312 )

#include <allegro.h>

typedef struct _tc_struct
{
    int color;
    int thickness;
} _tc_struct;

#define tc_to_i( x ) ((int)(void*)(_tc_struct*)(x))
#define i_to_tc( x ) ((_tc_struct*)(void*)(int)(x))


// draws a 1 width rect from top
void thickputpixel_t( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x, y + i_to_tc( color )->thickness, i_to_tc( color )->color );
}

// draws a 1 width rect from bottom
void thickputpixel_b( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x, y - i_to_tc( color )->thickness, i_to_tc( color )->color );
}

// draws a 1 height rect from right
void thickputpixel_r( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x - i_to_tc( color )->thickness, y, i_to_tc( color )->color );
}

void thickputpixel_l( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x + i_to_tc( color )->thickness, y, i_to_tc( color )->color );
}

void thickputpixel_tl( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x + i_to_tc( color )->thickness, y + i_to_tc( color )->thickness, i_to_tc( color )->color );
}

void thickputpixel_tr( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x - i_to_tc( color )->thickness, y + i_to_tc( color )->thickness, i_to_tc( color )->color );
}

void thickputpixel_bl( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x + i_to_tc( color )->thickness, y - i_to_tc( color )->thickness, i_to_tc( color )->color );
}

void thickputpixel_br( BITMAP *bmp, int x, int y, int color )
{
    rectfill( bmp, x, y, x - i_to_tc( color )->thickness, y - i_to_tc( color )->thickness, i_to_tc( color )->color );
}

//******************************************************************************

void thickline_t( BITMAP *bmp, int x1, int y1, int x2, int y2, int color )
{
    do_line( bmp, x1, y1, x2, y2, color, thickputpixel_t );
}

void thickline_b( BITMAP *bmp, int x1, int y1, int x2, int y2, int color )
{
    do_line( bmp, x1, y1, x2, y2, color, thickputpixel_b );
}
void thickline_r( BITMAP *bmp, int x1, int y1, int x2, int y2, int color )
{
    do_line( bmp, x1, y1, x2, y2, color, thickputpixel_r );
}

void thickline_l( BITMAP *bmp, int x1, int y1, int x2, int y2, int color )
{
    do_line( bmp, x1, y1, x2, y2, color, thickputpixel_l );
}

//******************************************************************************

void thickarc_tl( BITMAP *bmp, int x, int y, fixed angle1, fixed angle2, int r, int color )
{
    do_arc( bmp, x, y, angle1, angle2, r, color, thickputpixel_tl );
}

void thickarc_tr( BITMAP *bmp, int x, int y, fixed angle1, fixed angle2, int r, int color )
{
    do_arc( bmp, x, y, angle1, angle2, r, color, thickputpixel_tr );
}

void thickarc_bl( BITMAP *bmp, int x, int y, fixed angle1, fixed angle2, int r, int color )
{
    do_arc( bmp, x, y, angle1, angle2, r, color, thickputpixel_bl );
}

void thickarc_br( BITMAP *bmp, int x, int y, fixed angle1, fixed angle2, int r, int color )
{
    do_arc( bmp, x, y, angle1, angle2, r, color, thickputpixel_br );
}

//******************************************************************************

void drawRoundedRect( BITMAP *bitmap, int x1, int y1, int x2, int y2, int radius, int thickness, int color )
{
    _tc_struct tc;

    tc.thickness = thickness - 1;
    tc.color = color;


    thickarc_tl( bitmap, x1 + radius, y1 + radius, itofix(  64 ), itofix( 128 ), radius, tc_to_i( &tc ) );
    thickarc_tr( bitmap, x2 - radius, y1 + radius, itofix(   0 ), itofix(  64 ), radius, tc_to_i( &tc ) );
    thickarc_br( bitmap, x2 - radius, y2 - radius, itofix( 192 ), itofix(   0 ), radius, tc_to_i( &tc ) );
    thickarc_bl( bitmap, x1 + radius, y2 - radius, itofix( 128 ), itofix( 192 ), radius, tc_to_i( &tc ) );

    thickline_t( bitmap, x1 + radius, y1, x2 - radius, y1, tc_to_i( &tc ) );
    thickline_b( bitmap, x1 + radius, y2, x2 - radius, y2, tc_to_i( &tc) );
    thickline_l( bitmap, x1, y1 + radius, x1, y2 - radius, tc_to_i( &tc ));
    thickline_r( bitmap, x2, y1 + radius, x2, y2 - radius, tc_to_i( &tc ) );
}




  */

#endif