/******************************File********************************
 * I am the player class. I contain all te data for one player.
 * I contain the player's AI and pointers to the outside world that
 * the AI uses to make its decisions
 * 
 * This File Was Written:
 * 12/14/07/
 * By:
 * Wilson Saunders
 ******************************************************************/
#include <math.h>
#include "player.h"
#include "const.h"

Player::Player(){
	center = new TdPoint;
	dest = new TdPoint;
	position = new TdPoint;	// area I like to stand arround
	helper = new TdPoint;
	team = 0;	// the team I belong to
	isAI = true;	// toggel weather this player is under AI controll
		// positive, negative or 0 depending on if the AI or player 
		// thinks I shoiuld be moving in a certain direciton 
	xmove = ymove = 0;
	isPass = isStrike = false;
	tillPass = 0;
	tillStrike = 0;

	animState = 0;
	animFrame = 0;
}

Player::~Player(){
	delete(center);
	delete(dest);
	delete(position);
	delete(helper);
}

void Player::Init(BITMAP *imgs[]){
	int itor;
	for( itor =0; itor < 8; itor++){
		img[itor] = imgs[itor];
	}
}

void Player::SetPosition(int t, float xpos, float ypos){
	team = t;
	position->x = xpos;
	position->y = ypos;
}

// position and animation chainger
void Player::Update(){
	float toBall = center->DistTo2D(gState->ball);
		// sets x&y move to run after dest
	if(isAI){
		xmove = 0;
		if(center->x < dest->x-PLAYERDX) xmove = 1;
		if(center->x > dest->x+PLAYERDX) xmove = -1;
		ymove = 0;
		if(center->y < dest->y-PLAYERDY) ymove = 1;
		if(center->y > dest->y+PLAYERDY) ymove = -1;
			// decriment till variables untill ready to strike
		tillPass -= 1;
		tillStrike -= 1;
			// randomly try to pass or strike ball
		isPass = ( tillPass ==  0 && toBall < 50);
		isStrike = (tillStrike == 0 && toBall < 50);
			// start new count down
		if(tillPass <= 0) tillPass = 80 +rand()%40;
		if(tillStrike <= 0) tillStrike = 120 +rand()%40;
			// if ball is in the extremities of the field do not try and pass it
		if((gState->ball->x < -LEV_W*3/4 || gState->ball->x > LEV_W*3/4) &&
			rand()%4 != 1){
				isPass = false;
				isStrike = false;
			}
	}
		// do the pass and strike functions
	if(isPass)Pass();
	if(isStrike)Strike();
		// if the player has the ball slow the player down
	if(myNumber == gState->hasBall){
		xmove *= 0.8;
		ymove *= 0.8;
	}
		// if player is slide tackeling speed up for the first half 
		// and stop for the seccond
	if(animState == 3){
		if(animFrame < 8){
			xmove *= 2.0;
			ymove *= 2.0;
		}else{
			xmove *= 0.2;
			ymove *= 0.2;
		}
	}

		//do not move is player has fallen
	if(animState == 4){
		xmove *= 0.2;
		ymove *= 0.2;
	}

	if(isAI == false){
		xmove *= 1.3;
		ymove *= 1.3;
	}

	helper->Copy(center);
		// modify position based on x&y move
		// move diagonal
	if(xmove != 0 && ymove != 0){
		center->x += 7*xmove*PLAYERDX/10;
		center->y += 7*ymove*PLAYERDY/10;
	}else{
		center->x += xmove*PLAYERDX;
		center->y += ymove*PLAYERDY;
	}

	UpdateAnim(xmove != 0 || ymove != 0);
	if(xmove != 0 || ymove != 0){
		direction = helper->AngTo2D(center);
	}
		// prevent player from running out of bounds
	if( center->y > LEV_H)  center->y = LEV_H;
	if( center->y < -LEV_H)  center->y = -LEV_H;
	if( center->x > LEV_W)  center->x = LEV_W;
	if( center->x < -LEV_W)  center->x = -LEV_W;
		// make sure player is still moving in field
	if( dest->x > LEV_W || dest->x < -LEV_W ||
		dest->y > LEV_H || dest->y < -LEV_H)UpdateAI();

		// ignore collisions if I am sliding
	if(animState ==3) return;

		// move away from other players
	for(int itor = 0; itor < NUMPLAYERS; itor++){
		float dist = center->DistTo2D(gState->players[itor]);
			
		if(itor != myNumber && dist < PLAYERRAD*2 && dist > 0){
			float dx = center->x - gState->players[itor]->x;
			float dy = center->y - gState->players[itor]->y;
			center->x = gState->players[itor]->x + PLAYERRAD*2*dx/dist;
			center->y = gState->players[itor]->y + PLAYERRAD*2*dy/dist;
			if(rand() % 10 ==2 && myNumber < 10) center->y -= 8;
			if(rand() % 10 ==2 && myNumber >= 10) center->y += 8;
			// fall down
			if(gState->plState[itor] == 3 && animState != 4){
				gState->playSound(2);
				animState = 4;
				animFrame = 0;
			}
		}
	}

}

// I chainge the animation values based on program state
void Player::UpdateAnim(bool isMoving){
		// set to kick pose
	if( (animState ==0 || animState == 1)&&(isStrike || isPass)){
		animState = 2;
			//set to slide tackel
		if(isStrike && gState->hasBall != myNumber){
			animState = 3;
		}
	}
	if(animState == 2){
		animFrame +=1;
		if(animFrame >= 8){
			animFrame = 0;
			animState = 0;
		}
		return;
	}
		// slide update
	if(animState == 3){
		animFrame +=1;
		if(animFrame >= 16){
			animFrame = 0;
			animState = 0;
		}
		return;
	}
		// fallen update
	if(animState == 4){
		animFrame +=1;
		if(animFrame >= 24){
			animFrame = 0;
			animState = 0;
		}
		return;
	}
	animState =0;

	if(isMoving){
		animState = 1;
		animFrame +=1;
		if(animFrame >= 8) animFrame = 0;
	}
}

// I chainge the animation values based on program state
int Player::GetFrame(){
	switch(animState){
		case 0:
			return 0;
		case 1:
			return 4+(animFrame/2)%4;
		case 2:
			return 1;
		case 3:
			return 3;
		case 4:
			return 2;
	}
	return 0;
}

// I set the players destination somehwhere in the bounds of the his position
void Player::UpdateAI(){
	int itor;
	int dist = position->DistTo2D(gState->ball);;
	int ang = rand()%360;
		// run towards ball if not held by team mate
	if(	(gState->hasBall == -1 && dist < POSITIONRAD)||
		(myNumber < 10 && gState->hasBall >= 10 && dist < POSITIONRAD) ||
		(myNumber >= 10 && gState->hasBall < 10 && dist < POSITIONRAD))
	{
		dist = position->DistTo2D(gState->ball);
		if( dist > POSITIONRAD) dist = POSITIONRAD;
		ang = position->AngTo2D(gState->ball);
		dest->x = 0;
		dest->y = -dist;
		dest->RotateBy2D(ang);
		dest->Translate2D(position->x, position->y);
		return;
	}
		// run away from goal and opponents if I has ball
	if(myNumber == gState->hasBall){
		if(myNumber < 10){	// run left for blue
			dest->y = center->y;
			dest->x = center->x -40;
				// run away from other team's players
			for(itor = 10; itor < 20; itor++){
				if(center->DistTo2D(gState->players[itor]) < FEARDIST){
					if(gState->players[itor]->x > center->x){
						dest->x -=60;
					}else{
						dest->x +=60;
					}
					if(gState->players[itor]->y > center->y){
						dest->y -=60;
					}else{
						dest->y +=60;
					}
				}
			}
		}else{	// run right for red
			dest->y = center->y;
			dest->x = center->x +40;
			for(itor = 0; itor < 10; itor++){
				if(center->DistTo2D(gState->players[itor]) < FEARDIST){
					if(gState->players[itor]->x > center->x){
						dest->x -=60;
					}else{
						dest->x +=60;
					}
					if(gState->players[itor]->y > center->y){
						dest->y -=60;
					}else{
						dest->y +=60;
					}
				}
			}
		}

	}

		// default move randomly
	if(rand()% 30 != 2) return;
	dist = rand()%POSITIONRAD;
	ang = rand()%360;
	dest->x = 0;
	dest->y = -dist;
	dest->RotateBy2D(ang);
	dest->Translate2D(position->x, position->y);
	
}

	// I am the ball kicking funcitons, if the ball is close 
	// enough for me to act upon it I give the ball a new velocity
void Player::Pass(){
	float dist = center->DistTo2D(gState->ball);
	float ang;
	float tgtDist;
	if(dist > 3*PLAYERRAD) return;	// too far away to effect the ball
		// kick ball away from self if not in controll
	gState->playSound(1);
	if(dist > PLAYERRAD){
		ang = center->AngTo2D(gState->ball);
		helper->x = 0;
		helper->y = -PASSVELO;
		helper->RotateBy2D(ang);
		gState->ballDx = helper->x;
		gState->ballDy = helper->y;
		return;
	}
		// kick ball to closest team mate if in controll
	tgtDist = center->DistTo2D(gState->players[gState->tgtPlayer]);
	if(tgtDist < PASSRAINGE){
		ang = center->AngTo2D(gState->players[gState->tgtPlayer]);
	}else{
		ang = direction;
		tgtDist < PASSRAINGE;
	}
	helper->x = 0;
	helper->y = -PASSVELO;
	helper->RotateBy2D(ang);
	gState->ballDx = helper->x;
	gState->ballDy = helper->y;
		// move ball outside fo self
	gState->ball->Translate2D(helper->x*2, helper->y*2);
		// slow ball down for closer kicks
	gState->ballDx = gState->ballDx*tgtDist/PASSRAINGE;
	gState->ballDy = gState->ballDy*tgtDist/PASSRAINGE;
	return;
}

void Player::Strike(){
	float shake = (rand()%50)-25;
	float dist = center->DistTo2D(gState->ball);
	float ang;
	if(dist > PLAYERRAD) return;
		// play kick sound
	gState->playSound(1);
	helper->y = 0;
	if (myNumber < 10){
		helper->x = -LEV_W;
	}else{
		helper->x = LEV_W;
	}
	ang = center->AngTo2D(helper)+shake;
	helper->x = 0;
	helper->y = -STRIKEVELO;
	helper->RotateBy2D(ang);
	gState->ballDx = helper->x;
	gState->ballDy = helper->y;

}

//	void DrawShadow(Camera * cam);
///I draw debug values 
void Player::DrawTail(Camera* cam){
	TdPoint *temp = cam->WTS(center);
		// draw player position
	if( team == 1){
		circle(cam->screen, temp->x, temp->y, PLAYERRAD, makecol(200,0,0)); 
	}else{
		circle(cam->screen, temp->x, temp->y, PLAYERRAD, makecol(0,0,200)); 
	}
		// draw line to dest
	helper->Copy(cam->WTS(dest));
	temp = cam->WTS(center);
	line(cam->screen, temp->x, temp->y, helper->x, helper->y, makecol(0,100,200));
		// draw line to Position
	helper->Copy(cam->WTS(position));
	temp = cam->WTS(center);
	line(cam->screen, temp->x, temp->y, helper->x, helper->y, makecol(200,200,0));
		// draw positoin ring;
	circle(cam->screen, helper->x, helper->y, POSITIONRAD, makecol(150,150,0)); 


}

void Player::DrawPlayer(Camera* cam){
	int frame = GetFrame();
	TdPoint *temp = cam->WTS(center);
	float scail = cam->Yscale(center->y);
	bool flip = (direction > 0);

	if(fabs(direction) < 30){
		flip = (center->x < 0);
	}
	if(fabs(direction) >150){
		flip = (center->x > 0);
	}

	if(flip){
		pivot_scaled_sprite_v_flip(cam->screen, 
			img[frame], temp->x, temp->y, 44, 5, ftofix(128), ftofix(scail)); 
	} else{
		pivot_scaled_sprite(cam->screen,img[frame],
			temp->x, temp->y, 44, 70, itofix(0), ftofix(scail)); 
	}
}