/****************************Project*******************************
 * This Project is called "Top Down Shooter" for want of a better 
 * name. It will provide a rendering engine for a flying shooter similar
 * to 1984 and the many other top down arcade flying shooters. However
 * key improovements will be implimented to augment game play. First 
 * instead of following a set path and using the controll keys to manuver
 * about the screen, the controll keys will spin the plane on its yaw access
 * and have it accend and decend thus allowing the user greater freedom to
 * explore the world.
 *
 * This Project was Started
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Top Down Point Class. I contain functions that translate, 
 * rotate, copy, find angels, and distances between two points
 * 
 * This File Was Written:
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#ifndef __TDPOINT_H__
#define __TDPOINT_H__

class TdPoint {
public:
	TdPoint();
	~TdPoint();

	double DistTo2D(TdPoint* tgt);
	double DistTo3D(TdPoint* tgt);

	double AngTo2D(TdPoint* tgt);
	void Copy(TdPoint* tgt);

	void RotateBy2D(double angle);
	void Translate2D(double dx, double dy);
	void Translate3D(double dx, double dy, double dz);

	void SetFrac2D(TdPoint* tgt1, TdPoint* tgt2, double frac);
	void MakeWhole2D();

public:
	double x;
	double y;
	double z;

};

#endif
