/******************************File********************************
 * I am the Goalie class. I stand arround the goal and grab the 
 * ball if it is too close. I am not player controlled and I don't 
 * care how fast the ball is going I can catch it and throw it back;
 * 
 * This File Was Written:
 * 12/15/07/
 * By:
 * Wilson Saunders
 ******************************************************************/


#include "Goalie.h"
#include "const.h"

Goalie::Goalie(){
	center = new TdPoint;
	dest = new TdPoint;
	position = new TdPoint;	// area I like to stand arround
	helper = new TdPoint;
	animState = 0;

}

Goalie::~Goalie(){
	delete(center);
	delete(dest);
	delete(position);
	delete(helper);
}

void Goalie::Init(){}

void Goalie::SetPosition(int team, float xpos, float ypos){
	center->x = position->x = xpos;
	center->y = position->y = ypos;
}

void Goalie::Update(){
	float ang;
	float dx=0;
	float dy=0;
	// randomly set destination between ball and goal
	if( rand()%4 == 1){
		dest->y = -GOAL_H;
		dest->x = 0;
		ang = position->AngTo2D(gState->ball);
		dest->RotateBy2D(ang);
		dest->Translate2D(position->x, position->y);
	}
		// move goalie towards dest
	if(center->x < dest->x-PLAYERDX) dx = 2*PLAYERDX/3; 
	if(center->x > dest->x+PLAYERDX) dx = -2*PLAYERDX/3;

	if(center->y < dest->y-PLAYERDY) dy = 2*PLAYERDY/3;
	if(center->y > dest->y+PLAYERDY) dy = -2*PLAYERDY/3;

		// if diagonal movement reduce velocity
	if(dx != 0 && dy != 0){
		dx*= 0.7;
		dy*= 0.7;
	}
		// shift position
	center->x += dx;
	center->y += dy;
	
		// if Ball is within goalie's radius drop kick it.
	if(center->DistTo2D(gState->ball) < GOALIEGRAB){
		DropKick();
		gState->playSound(1);
	}
}

void Goalie::DropKick(){
	float mul =1;
	if( position->x > 0)mul = -1;
		// send ball flying
	helper->x = 0;
	helper->y = -STRIKEVELO;
	helper->RotateBy2D( 60 + rand()%60);
	helper->x*= mul;
	gState->ballDx = helper->x;
	gState->ballDy = helper->y;
	gState->ball->Translate2D(helper->x, helper->y);
}

void Goalie::Draw(Camera * cam){
	TdPoint *temp = cam->WTS(center);
	circle(cam->screen, temp->x, temp->y, GOALIEGRAB, makecol(0,0,0)); 

}