/****************************Project*******************************
 * This Project is a particle based flying fluid simulation. I render
 * Flying particles with drop shadow and highlighting via a multi pass
 * back buffer rendering system. All rendering is done via allegro 
 * sprites. The sprites are dynamicaly generated by draw primitives.
 *
 * This Project was Started
 * 11/27/07/
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the main function file. I hold the main funtion which creates 
 * the world and passes important data to it. I also am responsible
 * for the screen rendering, World update calling and maintaining 
 * the semaphores that prevent them from clobbering each other.
 * 
 * This File Was Written:
 * 11/27/07/
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <allegro.h>
#include "world.h"

// Globals
World * myWorld;
bool isTime;

/******************************************************************
 * I am timer call back function
 *****************************************************************/
void UpdateFunc(){
	isTime = true;
	return;
}

/******************************************************************
 * I am the program starting point and guardian of the game loop
 *****************************************************************/
int main(int argc, char *argv[])
{
	bool notDone = true;
	isTime = false;

		////////////////////////////////////////////
		//			Initilization Section
		////////////////////////////////////////////
	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_joystick(JOY_TYPE_AUTODETECT);

	set_color_depth(16);

		// initilize window
	//GFX_AUTODETECT_FULLSCREEN
	//GFX_AUTODETECT_WINDOWED
//	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 1024, 768, 0, 0) != 0) {
//	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 1024, 768, 0, 0) != 0) {
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0) {
			// if you are here graphic initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Graphics Initilization Failed");
		return 1;
	}
		// initilize world
	myWorld = new World;

	rest(100);	// wait for world to finish initilization
				// before starting timer


		// initilize timer
	if ( install_int(UpdateFunc, 30) != 0){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Timer Initilization Failed");
		return 1;
	}
		// intilize Mouse
	if ( install_mouse() == -1){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Mouse Initilization Failed");
		return 1;
	}
		// initilize sound
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Sound Initilization Failed");
      return 1;
    }
	

		////////////////////////////////////////////
		//			Game Loop Sections
		////////////////////////////////////////////
	while ( notDone )
	{
			// check keyboard for interface
		if (myWorld->menuState == -1) notDone = false;	// we are now done

		if(isTime){
			myWorld->Update();
			myWorld->Draw();
			blit( myWorld->myCamera->screen , screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
			isTime =false;
		}
		
		rest(1);

		

	}	
		////////////////////////////////////////////
		//			Clean Up Time
		////////////////////////////////////////////
//	allegro_exit(); 

//	return 0;
}
END_OF_MAIN();
