/****************************Project*******************************
 * This Project is called "Top Down Shooter" for want of a better 
 * name. It will provide a rendering engine for a flying shooter similar
 * to 1984 and the many other top down arcade flying shooters. However
 * key improovements will be implimented to augment game play. First 
 * instead of following a set path and using the controll keys to manuver
 * about the screen, the controll keys will spin the plane on its yaw access
 * and have it accend and decend thus allowing the user greater freedom to
 * explore the world.
 *
 * This Project was Started
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the camera class I provide the key interface between the screen
 * and the world. I contain a pointer to the draw buffer. However I
 * am ment to be passed to individaul classes for their draw function.
 * My key funcitons are screen to world (STW) and world to screen (WTS)
 * I also contain position data for the current camera location and its
 * orientation to the world
 * 
 * This File Was Written:
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "camera.h"
#include <allegro.h>
#include <math.h>



/******************************************************************
 * I am the constructor. I create all data objects for this game.
 * I also handle default variable setting.
 ******************************************************************/
Camera::Camera(){

	center = new TdPoint;
	out = new TdPoint;
	xoff  = SCREEN_W/2;
	yoff  = SCREEN_H/2;

	screen = create_bitmap(SCREEN_W, SCREEN_H);
	

}

Camera::~Camera(){
	delete(center);
	delete(out);
}


/******************************************************************
 * I am the initilization function. I save the external bitmap into
 * the internal varialbe src.
 ******************************************************************/
void Camera::Init(BITMAP *src){
	screen = src;
}


/******************************************************************
 * I am the inside screen checker funciotn I check weather or not
 * the point is inside the screen and there for if it should be rendered
 ******************************************************************/
bool Camera::IsInScreen(TdPoint * tgt){
	if( tgt->x < center->x || tgt->x > center->x + SCREEN_W ||
		tgt->y < center->y || tgt->y > center->y + SCREEN_H )
	{
		return false;
	}
	return true;
}


/******************************************************************
 * I am the World to screen converter function. When I am done 
 * the out point will be in the screen location
 ******************************************************************/
TdPoint * Camera::WTS(TdPoint * tgt){
	double scail = Yscale(tgt->y);
	out->x = WTSx(tgt->x* scail);
	out->y = 300+(tgt->y);///2 +450;//WTSy((tgt->y+300)/2);

	return out;
}



/******************************************************************
 * I am the Screen to World converter function. When I am done 
 * the out point will be in the world location relative to the screen
 ******************************************************************/
TdPoint * Camera::STW(TdPoint * tgt){

	out->x = STWx(tgt->x);
	out->y = STWy(tgt->y);

	return out;
}


/******************************************************************
 * We are the individual emement converters. 
 ******************************************************************/
double Camera::STWx(double Xin){
	return (Xin- xoff )+center->x;
}
double Camera::STWy(double Yin){
	return (Yin- yoff )+center->y;
}
double Camera::WTSx(double Xin){
	return (Xin -center->x)+ xoff;
}
double Camera::WTSy(double Yin){
	return (Yin -center->y)+ yoff;
}

/// I am the y scailing funciton. To show a vanishing point
/// a y value of 300 will return a 1 and a value of -300 will
/// return a value of .5. there is a linea interpolation between 
/// the two extreams
double Camera::Yscale(double Yin){
	if(Yin < -300) return 0.5;
	if(Yin >  300) return 1.0;

	Yin += 300;
	Yin = (Yin/600)* 0.5 + 0.5;

	return Yin;
}
