/****************************Project*******************************
 * This Project is called "Top Down Shooter" for want of a better 
 * name. It will provide a rendering engine for a flying shooter similar
 * to 1984 and the many other top down arcade flying shooters. However
 * key improovements will be implimented to augment game play. First 
 * instead of following a set path and using the controll keys to manuver
 * about the screen, the controll keys will spin the plane on its yaw access
 * and have it accend and decend thus allowing the user greater freedom to
 * explore the world.
 *
 * This Project was Started
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Top Down Point Class. I contain functions that translate, 
 * rotate, copy, find angels, and distances between two points
 * 
 * This File Was Written:
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <math.h>
#include "TdPoint.h"



/*****************************************************************
 * I am the constructor, I initilize the internal values
 ******************************************************************/
TdPoint::TdPoint(){
	z = x = y = 0;
}

/*****************************************************************
 * I am the destructor, I exist for good form
 ******************************************************************/
TdPoint::~TdPoint(){}


/*****************************************************************
 * I am the allocator function I set this PozePoint to the value in
 * the tgt Poze point
 ******************************************************************/
void TdPoint::Copy(TdPoint * tgt){
	x = tgt->x;
	y = tgt->y;
	z = tgt->z;
}


/*****************************************************************
 * I am the distance finder 3 dimentional
 ******************************************************************/
double TdPoint::DistTo3D(TdPoint * tgt){
	double dx = x - tgt->x ;
	double dy = y - tgt->y;
	double dz = z - tgt->z; 
	return sqrt(dx*dx + dy*dy + dz*dz);
}

/*****************************************************************
 * I am the distance finder 2 dimentional
 ******************************************************************/
double TdPoint::DistTo2D(TdPoint * tgt){
	double dx = x - tgt->x ;
	double dy = y - tgt->y;

	return sqrt(dx*dx + dy*dy );
}

/*****************************************************************
 * I am the flat angel finder I return the angel in degrees 
 * from this point to the tgt of north ie (x,y)=(0,1)
 ******************************************************************/
double TdPoint::AngTo2D(TdPoint * tgt){
	double dx = x - tgt->x ;
	double dy = y - tgt->y;
	double hyp = sqrt(dx*dx + dy*dy);
		// return 0 if points are on top of each other
	if(hyp == 0)	return 0;

	if(dx > 0){
		return acos(dy/hyp)*-57.29579;
	} 
	
	return acos(dy/hyp)*57.29579;

}


/*****************************************************************
 * I am the angel rotation. I rotate this point arround the origin
 * (0,0) by the degree specified. arround the Z axis.
 ******************************************************************/
void TdPoint::RotateBy2D(double degree)
{
		// since <math.h> only handels radian calculation
		// and I like to work in degrees this is the 
		// converter number
	double DtoR = 0.0174532925;
	double si = sin(degree*DtoR);
	double co = cos(degree*DtoR);
		// store old values so they will not get
		//  altered befor the seccond stp of the calculation
	double oldX = x;
	double oldY = y;

	x = co*oldX - si*oldY;
	y = co*oldY + si*oldX;
		// by now the x and y values have been rotated
	return;
}


/*****************************************************************
 * I am the translate funciton I add the delta vector to the current
 * point
 ******************************************************************/
void TdPoint::Translate2D(double dx, double dy){
	x += dx;
	y += dy;
}

/*****************************************************************
 * I am the translate funciton I add the delta vector to the current
 * point
 ******************************************************************/
void TdPoint::Translate3D(double dx, double dy, double dz ){
	x += dx;
	y += dy;
	z += dz;
}


/*****************************************************************
 * I am the set frac function. Given how often I am goint to do 
 * weighted averages on two points. I deserve my own funciton
 ******************************************************************/
void TdPoint::SetFrac2D(TdPoint* tgt1, TdPoint* tgt2, double frac){
	x = tgt2->x*frac + tgt1->x*(1-frac);
	y = tgt2->y*frac + tgt1->y*(1-frac);
}

/*****************************************************************
 * I am the make whole function. I set x and y to their integer values
 * via truncation
 ******************************************************************/
void TdPoint::MakeWhole2D (){
	x = (int)x;
	y = (int)y;
}