/******************************File********************************
 * I am the World class I contain all ingame objects. I am responsible
 * for calling the update and render funcitons at the appropriate times
 * 
 * This File Was Written:
 * 12/14/07/
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "world.h"
#include "const.h"
#include <math.h>
#include <string.h>

/******************************************************************
 * I am the constructor I initilize memory and set defaults
 ******************************************************************/
World::World(){
	int itor;
	myCamera = new Camera;
	gState = new GlobalState;
	mouseLoc = new TdPoint;
	helper = new TdPoint;
	helper1 = new TdPoint;
	helper2 = new TdPoint;
		// put center in the center of the screen
	center= new TdPoint;
	center->x = 0;//SCREEN_W/2;
	center->y = 0;//SCREEN_H/2;
	
		// create players
	for(itor =0; itor < NUMPLAYERS; itor++){
		player[itor] = new Player;
		player[itor]->myNumber = itor;
		gState->players[itor] = player[itor]->center;
		player[itor]->gState = gState;

	}
		// create goalies
	goalie[0]= new Goalie;
	goalie[1]= new Goalie;
	goalie[0]->gState = gState;
	goalie[1]->gState = gState;
	Reset();
	Init();

	for(itor = 0; itor< 25; itor++){
		SortIndex[itor] = 1;
		SortDepth[itor] = 0;
	}

	menuState = 1;
}


/******************************************************************
 * I am the destructor. I clean up memory initilized in the constructor
 ******************************************************************/
World::~World(){
	int itor;
	delete(myCamera);
	delete(center);
	delete(helper);
	delete(helper1);
	delete(helper2);
	delete(mouseLoc);

	delete(gState);
	for(itor =0; itor < NUMPLAYERS; itor++){
		delete(player[itor]);
	}

	delete(goalie[0]);
	delete(goalie[1]);
}

/******************************************************************
 * I am the reset funciton. I set all atributes to their starting values
 ******************************************************************/
void World::Reset(){
	SetKickOff(1);
	SetKickOff(2);
	for(int itor = 0; itor < NUMPLAYERS; itor++){
		player[itor]->center->Copy(player[itor]->dest) ;
	}
	goalie[0]->SetPosition(1, -LEV_W,0);
	goalie[1]->SetPosition(2, LEV_W,0);
	gState->tillKickoff = KICKOFFTIME;
	gState->Reset();
}

/******************************************************************
 * I am the texture loader function. I fill all relivent bitmaps with
 * the correct data from file
 ******************************************************************/
void World::Init(){
	int itor;
	char pathR[20];// = "data\\r0.bmp";
	char pathB[20];// = "data\\b0.bmp";
	strncpy(pathR, "data\\r0.bmp",20);
	strncpy(pathB, "data\\b0.bmp",20);
	field = load_bitmap("data\\fieldshort.bmp",pal);

	flagR = load_bitmap("data\\RedFlag.bmp",pal);
	flagB = load_bitmap("data\\BlueFlag.bmp",pal);
	ballImg = load_bitmap("data\\ball.bmp",pal);
	shadow[0] = load_bitmap("data\\shadow0.bmp",pal);
	shadow[1] = load_bitmap("data\\shadow1.bmp",pal);
	shadow[2] = load_bitmap("data\\shadow2.bmp",pal);
	shadow[3] = load_bitmap("data\\shadow3.bmp",pal);
		// load player images
	for(itor =0; itor < 8; itor++){
		pathR[6]= '0'+itor;
		redImg[itor]  = load_bitmap(pathR,pal);
		pathB[6]= '0'+itor;
		blueImg[itor] = load_bitmap(pathB,pal);
	}
		// save to player
	for(itor =0; itor <10; itor++){
		player[itor]->Init(blueImg);
		player[itor+10]->Init(redImg);
	}

		// load menu date
	menu = load_bitmap("data\\menu.bmp",pal);
	selector = load_bitmap("data\\b3.bmp",pal);

	winR = load_bitmap("data\\redwin.bmp",pal);
	winB = load_bitmap("data\\bluewin.bmp",pal);

}


/******************************************************************
 * We are the player position funcitons. We set the player positions.
 * based off the user's request
 ******************************************************************/
void World::SetKickOff(int side){
	int mul = 1;
	int ofs = 0;
	int itor;
	if( side == 1){
		mul = -1;
		ofs = 10;
	}
		// test placement
	for(itor =0; itor < NUMPLAYERS/2; itor++){
		player[itor+ofs]->SetPosition(side,900*mul,(itor-5) *600/10);
	}
//	return;
		// actual placement
	player[0+ofs]->SetPosition(side, 147* mul, -210);
	player[1+ofs]->SetPosition(side, 173* mul, -123);
	player[2+ofs]->SetPosition(side, 173* mul, 123);
	player[3+ofs]->SetPosition(side, 147* mul, 210);
	player[4+ofs]->SetPosition(side, 362* mul, -77);
	player[5+ofs]->SetPosition(side, 170* mul, 0);
	player[6+ofs]->SetPosition(side, 362* mul, 77);
	player[7+ofs]->SetPosition(side, 632* mul, -206);
	player[8+ofs]->SetPosition(side, 625* mul, 0);
	player[9+ofs]->SetPosition(side, 632* mul, 260);

	for(itor =0; itor < NUMPLAYERS/2; itor++){
		player[itor+ofs]->dest->Copy(player[itor+ofs]->position);
		player[itor+ofs]->direction = 0;
	}

}


/******************************************************************
 * I set a more offensive field position
 ******************************************************************/
void World::SetOffense(int side){
	int mul = 1;
	int ofs = 0;
	int itor;
	if( side == 1){
		mul = -1;
		ofs = 10;
	}
	player[0+ofs]->SetPosition(side, -552* mul, -210);
	player[1+ofs]->SetPosition(side, -511* mul, -59);
	player[2+ofs]->SetPosition(side, -511* mul, 59);
	player[3+ofs]->SetPosition(side, -552* mul, 210);
	player[4+ofs]->SetPosition(side, -290* mul, -186);
	player[5+ofs]->SetPosition(side, -244* mul, 0);
	player[6+ofs]->SetPosition(side, -290* mul, 186);
	player[7+ofs]->SetPosition(side, 70* mul, -195);
	player[8+ofs]->SetPosition(side, 33* mul, 0);
	player[9+ofs]->SetPosition(side, 70* mul, 195);
}

/******************************************************************
 * I set a more midle field position
 ******************************************************************/
void World::SetMidField(int side){
	int mul = 1;
	int ofs = 0;
	int itor;
	if( side == 1){
		mul = -1;
		ofs = 10;
	}
	player[0+ofs]->SetPosition(side, -277* mul, -210);
	player[1+ofs]->SetPosition(side, -261* mul, -59);
	player[2+ofs]->SetPosition(side, -261* mul, 59);
	player[3+ofs]->SetPosition(side, -277* mul, 210);
	player[4+ofs]->SetPosition(side, -30* mul, -186);
	player[5+ofs]->SetPosition(side, -44* mul, 0);
	player[6+ofs]->SetPosition(side, -30* mul, 186);
	player[7+ofs]->SetPosition(side, 412* mul, -195);
	player[8+ofs]->SetPosition(side, 433* mul, 0);
	player[9+ofs]->SetPosition(side, 412* mul, 195);
}

/******************************************************************
 * I set a more defensive field position
 ******************************************************************/
void World::SetDefense(int side){
	int mul = 1;
	int ofs = 0;
	int itor;
	if( side == 1){
		mul = -1;
		ofs = 10;
	}
	player[0+ofs]->SetPosition(side, -117* mul, -210);
	player[1+ofs]->SetPosition(side, -111* mul, -59);
	player[2+ofs]->SetPosition(side, -111* mul, 59);
	player[3+ofs]->SetPosition(side, -117* mul, 210);
	player[4+ofs]->SetPosition(side, 254* mul, -186);
	player[5+ofs]->SetPosition(side, 244* mul, 0);
	player[6+ofs]->SetPosition(side, 254* mul, 186);
	player[7+ofs]->SetPosition(side, 562* mul, -195);
	player[8+ofs]->SetPosition(side, 582* mul, 0);
	player[9+ofs]->SetPosition(side, 562* mul, 195);
}

/******************************************************************
 * I am the update function. I update the position of every object 
 * in the world. I am also responsible for calling interctions between
 * unconnected world objects
 ******************************************************************/
void World::Update(){
		// escape to main menu
	if(key[KEY_ESC]) menuState = 5;
		// handel victory state
	if(menuState > 8) return;

		// handel menu system
	if(menuState != 0 ){
		if(key[KEY_UP] && rUser == 1)	menuState-= 1;
		if(key[KEY_DOWN]&& rUser == 1) menuState += 1;
		rUser = 1;
		if(key[KEY_UP] || key[KEY_DOWN]) {
			rUser = 0;
		}
		if(menuState < 1)menuState = 1;
		if(menuState > 5)menuState = 5;
			// check sellection
		if(key[KEY_ENTER]){
			switch(menuState){
				case 1:
					rUser = 15;
					bUser = -1;
					menuState = 0;
					Reset();
					break;
				case 2:
					rUser = -1;
					bUser = 5;
					menuState = 0;
					Reset();
					break;
				case 3:
					rUser = 15;
					bUser = 5;
					menuState = 0;
					Reset();
					break;
				case 4:
					rUser = -1;
					bUser = -1;
					menuState = 0;
					Reset();
					break;
				case 5:
					menuState = -1;
					break;
				case 6:
					menuState = -1;
					break;
			}
		}


		return;
	}

		// automaticaly set field positions pre kickoff
	if(gState->tillKickoff > 0){
		SetKickOff(1);
		SetKickOff(2);

			// decriment kickoff timer 
		gState->tillKickoff -=1;
		if(gState->tillKickoff < KICKOFFTIME/3){
			for(int itor = 0; itor < NUMPLAYERS; itor++){
				player[itor]->center->Copy(player[itor]->dest);
				player[itor]->direction = 0;
			}
			gState->ball->x = 0;
			gState->ball->y = 0;
		} else{
			gState->ball->x = 0;
			gState->ball->y = 900;
		}
	}else{	// set game play position
		if(gState->ball->x < -LEV_W/3){
			SetOffense(2);
			SetDefense(1);
		} else if(gState->ball->x < LEV_W/3){
			SetMidField(1);
			SetMidField(2);
		}else {
			SetOffense(1);
			SetDefense(2);
		}
	}

		// controll posessed players
	for(int itor =10; itor < 20; itor++){
		player[itor]->isAI = true;
		if(itor==rUser) 
			player[itor]->isAI = false;
		gState->plState[itor] = player[itor]->animState;
	}
	for(int itor = 0; itor < 10; itor++){
		player[itor]->isAI = true;
		if(itor==bUser)
			player[itor]->isAI = false;
		gState->plState[itor] = player[itor]->animState;
	}

	// process user input
	InputHandel();


	UpdateBall();
	UpdatePlayers();
	goalie[0]->Update();
	goalie[1]->Update();
		// fill sort order
	for( itor = 0; itor < 20; itor++){
		AddSortElement(itor, player[itor]->center->y,itor);
	}
	AddSortElement(-1, gState->ball->y,20);
	AddSortElement(-2, goalie[1]->center->y,21);
	AddSortElement(-3, goalie[0]->center->y,22);
		// check end game condition
	if( gState->timer < 0 && gState->Rscore > gState->Bscore){
		this->menuState =10;
	}
	if( gState->timer < 0 && gState->Rscore < gState->Bscore){
		this->menuState =11;
	}

}


/******************************************************************
 * I am the update function for the ball physics
 ******************************************************************/
void World::UpdateBall(){
	int itor;
	float bestAng = 500;
	float ang;
	float dist;
		// save old ball position
	helper->Copy(gState->ball);

	
	gState->timer -=1;
	gState->hasBall = -1;



		// update ball
	gState->ball->x +=gState->ballDx;
	gState->ball->y +=gState->ballDy;
	gState->ballDx *= BALLGDAMPEN;
	gState->ballDy *= BALLGDAMPEN;
	if(fabs(gState->ballDx) < 1) gState->ballDx = 0;
	if(fabs(gState->ballDy) < 1) gState->ballDy = 0;
		// reboundball off sides
	if(gState->ball->y < -LEV_H && gState->ballDy < 0) gState->ballDy*= -1;
	if(gState->ball->y > LEV_H && gState->ballDy > 0) gState->ballDy*= -1;
	if(gState->ball->x < -LEV_W && gState->ballDx < 0) {
		gState->ballDx*= -1;
			// check for goal
		if( gState->ball->y > -GOAL_H && gState->ball->y < GOAL_H){
			gState->ball->x = 0;
			gState->Bscore+=1;
			gState->tillKickoff = KICKOFFTIME;
			gState->playSound(0);	// play goal sound
		}
	}
	if(gState->ball->x > LEV_W && gState->ballDx > 0){
		gState->ballDx*= -1;
		// check for goal
		if( gState->ball->y > -GOAL_H && gState->ball->y < GOAL_H){
			gState->ball->x = 0;
			gState->Rscore+=1;
			gState->tillKickoff = KICKOFFTIME;
			gState->playSound(0);	// play goal sound
		}
	}

		
		// claim ball
	if(gState->ballDx* gState->ballDx+ gState->ballDy*gState->ballDy < CATCHVELO*CATCHVELO){
		for(itor =0; itor < NUMPLAYERS ; itor++){
			if(gState->ball->DistTo2D(player[itor]->center) < BALLGRABRAD && 
					(player[itor]->animState == 0 || player[itor]->animState == 1))
			{
				gState->ball->Copy(player[itor]->center);
				gState->hasBall = itor;
				if( itor <10 && bUser >=0)  bUser = itor;
				if( itor >=10 && rUser >=0)  rUser = itor;
				
			}
		}
	}else {	// bounce off player
		for(itor =0; itor < NUMPLAYERS ; itor++){
			dist =gState->ball->DistTo2D(player[itor]->center);
			if(dist  < PLAYERRAD*3/2 &&
				helper->DistTo2D(player[itor]->center) > dist)
			{
				helper1->x = gState->ballDx;
				helper1->y = gState->ballDy;
				ang = player[itor]->center->AngTo2D(gState->ball);
				helper1->RotateBy2D(-ang);
				if(helper1->y > 0) helper1->y *= -1;
				helper1->RotateBy2D(ang);
				gState->ballDx = helper1->x;
				gState->ballDy = helper1->y;
				//gState->ball->Copy(player[itor]->center);
				//gState->hasBall = itor;
			}
		}

	}

}


/******************************************************************
 * I am the update function for the players
 ******************************************************************/
void World::UpdatePlayers(){
	int itor;
	float ang;
	float bestAng = 500;
		// pick target player to pass for first team
	if(gState->hasBall >-1 && gState->hasBall< 10){
		for(itor = 0; itor < 10; itor++){
			ang = player[gState->hasBall]->center->AngTo2D(player[itor]->center);
			if( itor != gState->hasBall && 
				fabs(player[gState->hasBall]->direction - ang) < bestAng)
			{
				bestAng = fabs(player[gState->hasBall]->direction - ang);
				gState->tgtPlayer = itor;
			}
		}
	}
		// pick target player to pass for seccond team
	if(gState->hasBall >-1 && gState->hasBall >= 10){
		for(itor = 10; itor < 20; itor++){
			ang = player[gState->hasBall]->center->AngTo2D(player[itor]->center);
			if( itor != gState->hasBall && 
				player[gState->hasBall]->center->DistTo2D(player[itor]->center) < POSITIONRAD &&
				fabs(player[gState->hasBall]->direction - ang) < bestAng)
			{
				bestAng = fabs(player[gState->hasBall]->direction - ang);
				gState->tgtPlayer = itor;
			}
		}
	}


		// update all players in alternating sequences
	if(gState->timer%2 == 1){
		for(itor =0; itor < NUMPLAYERS; itor++){
			player[itor]->Update();
			player[itor]->UpdateAI();
		}
	}else{
		for(itor = NUMPLAYERS-1; itor >= 0; itor-=1){
			player[itor]->Update();
			player[itor]->UpdateAI();
			
		}
	}

}

/******************************************************************
 * I am the User controll function. I 
 ******************************************************************/
void World::InputHandel(){
	int itor;
		// copy mouse position to mouseloc
	mouseLoc->x = mouse_x;
	mouseLoc->y = mouse_y;
		// on mouse
	if(mouse_b & 1) {
		gState->ball->Copy(myCamera->STW(mouseLoc));
	}
	if(mouse_b & 2) {
		player[0]->position->Copy(myCamera->STW(mouseLoc));
	}


	 myCamera->center->x = gState->ball->x;
		// prevent camera from leaving bounds
	if(myCamera->center->x < SCREEN_W/3-LEV_W) 
		myCamera->center->x = SCREEN_W/3-LEV_W;
	if(myCamera->center->x > LEV_W-SCREEN_W/3) 
		myCamera->center->x = LEV_W-SCREEN_W/3;

		// use arrow keys to active player direction
	if(this->rUser >= 0){
		player[rUser]->xmove = 0;
		player[rUser]->ymove = 0;
			// set movement
		if(key[KEY_UP])	player[rUser]->ymove -= 1;
		if(key[KEY_DOWN]) player[rUser]->ymove += 1;
		if(key[KEY_LEFT]) player[rUser]->xmove -= 1;
		if(key[KEY_RIGHT]) player[rUser]->xmove += 1;
			//set pass and strike
		player[rUser]->isPass =(key[KEY_LCONTROL]||key[KEY_RCONTROL] || key[KEY_Z]);
		player[rUser]->isStrike =(key[KEY_ALT]||key[KEY_ALTGR]||key[KEY_X]);
			// use tab to select closest player
		if( key[KEY_TAB]|| key[KEY_C]){
			float minDist = 9000;
			for(int itor = 10; itor < 20; itor++){
				if( player[itor]->center->DistTo2D(gState->ball) < minDist){
					minDist = player[itor]->center->DistTo2D(gState->ball);
					rUser = itor;
				}
			}
		}
	}
		// use joysticks  0 to controll blue player
	poll_joystick();
	if(this->bUser >= 0){
		player[bUser]->xmove = 0;
		player[bUser]->ymove = 0;
			// set movement
		if(joy[0].stick[0].axis[1].d1)	player[bUser]->ymove -= 1;
		if(joy[0].stick[0].axis[1].d2) player[bUser]->ymove += 1;
		if(joy[0].stick[0].axis[0].d1) player[bUser]->xmove -= 1;
		if(joy[0].stick[0].axis[0].d2) player[bUser]->xmove += 1;
			//check buttons
		player[bUser]->isPass =(joy[0].button[0].b);
		player[bUser]->isStrike =(joy[0].button[1].b);
			// use tab to select closest player
		if( joy[0].button[2].b){
			float minDist = 9000;
			for(int itor = 0; itor < 10; itor++){
				if( player[itor]->center->DistTo2D(gState->ball) < minDist){
					minDist = player[itor]->center->DistTo2D(gState->ball);
					bUser = itor;
				}
			}
		}
	}
      ///* Process input for the first joystick */
      //if (joy[0].button[0].b)
      //   first_button_pressed();

      //if (joy[0].button[1].b)

		
}


/******************************************************************
 * I am the sort helper function. 
 ******************************************************************/
void World::AddSortElement(int index, float val, int round){
	int itor;
	int bitor;	// reverse itor
	for(itor = 0; itor < round; itor++){
		if( val < SortDepth[itor]){
				// copy elements from round backwards to make room for new element
			for(bitor = round; bitor >= itor; bitor -=1){
				SortIndex[bitor+1] = SortIndex[bitor];
				SortDepth[bitor+1] = SortDepth[bitor];
			}
				// insert sucess
			SortIndex[itor] = index;
			SortDepth[itor] = val;
			return;
		}
	}
	
	SortIndex[round] = index;
	SortDepth[round] = val;
}


/******************************************************************
 * I am the draw function. I am responsible for prepairing the back
 * buffer stored in myCamera->screen
 ******************************************************************/
void World::Draw(){
	int itor;
	TdPoint * temp;
	int index;
		// reset to black
	clear_to_color(myCamera->screen, makecol(0, 0, 0));
	draw_sprite(myCamera->screen, field, myCamera->WTSx(0),SCREEN_H-field->h);
	draw_sprite_h_flip(myCamera->screen, field, myCamera->WTSx(-field->w),SCREEN_H-field->h);

		// draw victory states
	if( menuState == 10){
		draw_sprite(myCamera->screen, winR,SCREEN_W/2-winR->w/2, SCREEN_H/2-winR->h/2);
		return;
	}
	if( menuState == 11){
		draw_sprite(myCamera->screen, winB,SCREEN_W/2-winB->w/2, SCREEN_H/2-winR->h/2);
		return;
	}


		// draw menu then exit
	if(menuState > 0){
		draw_sprite(myCamera->screen, menu,SCREEN_W/2-menu->w/2,0);
		draw_sprite(myCamera->screen, selector, 620, 138+43*menuState);
		draw_sprite_h_flip(myCamera->screen,redImg[1], 100, 138+43*menuState);
		draw_sprite(myCamera->screen, selector, 620, 138+43*menuState);
		return;
	}

		// draw players
	for(itor =0; itor < NUMPLAYERS; itor++){
////		player[itor]->DrawTail(myCamera);
////		player[itor]->DrawPlayer(myCamera);
//		DrawObj(itor);
		index = 4*(player[itor]->center->y+LEV_H)/(LEV_H*2);
		if (index < 0)index = 0;
		if(index > 3)index = 3;
		temp = myCamera->WTS(player[itor]->center );
		draw_sprite(myCamera->screen, shadow[index], temp->x-33, temp->y-17);

	}
//		// draw goalies
	index = 4*(goalie[0]->center->y+LEV_H)/(LEV_H*2);
	if (index < 0)index = 0;
	if(index > 3)index = 3;
	temp = myCamera->WTS(goalie[0]->center );
	draw_sprite(myCamera->screen, shadow[index], temp->x-33, temp->y-17);
	index = 4*(goalie[0]->center->y+LEV_H)/(LEV_H*2);
	if (index < 0)index = 0;
	if(index > 3)index = 3;
	temp = myCamera->WTS(goalie[1]->center );
	draw_sprite(myCamera->screen, shadow[index], temp->x-33, temp->y-17);
	index = 0;//4*(gState->ball->y+LEV_H)/(LEV_H*2);
	if (index < 0)index = 0;
	if(index > 3)index = 3;
	temp = myCamera->WTS(gState->ball );
	draw_sprite(myCamera->screen, shadow[index], temp->x-33, temp->y-17);
//	goalie[0]->Draw(myCamera);
//	goalie[1]->Draw(myCamera);
//
//		// draw ball
//	temp = myCamera->WTS(gState->ball);
//	circle(myCamera->screen, temp->x, temp->y, 5, makecol(250,250,250)); 
		// draw all objects in sort array
	for(itor = 0; itor< 23; itor++){
		DrawObj(SortIndex[itor]);
	}

		// highlight pass target
	if(gState->hasBall > -4){
		temp = myCamera->WTS(gState->players[gState->tgtPlayer]);
		if(temp->x < 3) temp->x = 3;
		if(temp->x > SCREEN_W-3)temp->x = SCREEN_W-3;
		circlefill(myCamera->screen, temp->x, temp->y-50, 4, makecol(0,0,0));
		circlefill(myCamera->screen, temp->x, temp->y-50, 2, makecol(250,250,250)); 
	}
		// highlight active user
	if( rUser >= 0 ){
		temp = myCamera->WTS(gState->players[rUser]);
		if(temp->x < 3) temp->x = 3;
		if(temp->x > SCREEN_W-3)temp->x = SCREEN_W-3;
		draw_sprite(myCamera->screen, flagR,temp->x-18, temp->y-90);
		//circlefill(myCamera->screen, temp->x, temp->y, PLAYERRAD, makecol(250,0,0)); 
	}
	if( bUser >= 0 ){
		temp = myCamera->WTS(gState->players[bUser]);
		if(temp->x < 3) temp->x = 3;
		if(temp->x > SCREEN_W-3)temp->x = SCREEN_W-3;
		draw_sprite(myCamera->screen, flagB,temp->x-18, temp->y-90);
		//circlefill(myCamera->screen, temp->x, temp->y, PLAYERRAD, makecol(0,0,250)); 
	}


//	myCamera->STW(mouseLoc);
//	textprintf_ex(myCamera->screen,font, 0,0, makecol(200, 0, 0), 
//		-1, "%f, %f", myCamera->out->x, myCamera->out->y); 
	
	/*textprintf_ex(myCamera->screen,font, 400,0, makecol(200, 0, 0), 
		-1, "%d : %d", gState->timer/TMPM, (gState->timer%TMPM)/TMPS ); 
	textprintf_ex(myCamera->screen,font, 200,0, makecol(200, 0, 0), 
		-1, "Red : %d", gState->Rscore ); 
	textprintf_ex(myCamera->screen,font, 500,0, makecol(0, 0, 200), 
		-1, "Blue : %d", gState->Bscore );*/
	textprintf_centre_ex(myCamera->screen,font,401,4, makecol(0, 0, 0), -1,
		"Red Score: %d     [ %d : %d ]   Blue Score: %d",
		gState->Rscore, gState->timer/TMPM, (gState->timer%TMPM)/TMPS, gState->Bscore );
	textprintf_centre_ex(myCamera->screen,font, 400,3, makecol(250, 250, 250), -1,
		"Red Score: %d     [ %d : %d ]   Blue Score: %d",
		gState->Rscore, gState->timer/TMPM, (gState->timer%TMPM)/TMPS, gState->Bscore );
//	DrawCursor();
}

/******************************************************************
 * I am the cursor drawing funciton. I render the mouse in a way
 * that conveys the angle and velocity of the blood spray.
 ******************************************************************/
void World::DrawCursor(){
		// draw line 1
	line(myCamera->screen, mouseLoc->x, mouseLoc->y-20, 
			mouseLoc->x, mouseLoc->y+20, makecol(200, 0, 0)); 
	line(myCamera->screen, mouseLoc->x-20, mouseLoc->y, 
			mouseLoc->x+20, mouseLoc->y, makecol(200, 0, 0)); 
	
}

/******************************************************************
 * I am the draw object function. I Render the object indexed by the
 * index number
 ******************************************************************/
void World::DrawObj(int index){
	TdPoint * temp;
	float scail;
	if(index >=0){
		player[index]->DrawPlayer(myCamera);
		return;
	}

	if( index == -3){	// draw red goalie
		temp = myCamera->WTS(goalie[0]->center);
		scail = myCamera->Yscale(goalie[0]->center->y);
		pivot_scaled_sprite_v_flip(myCamera->screen, 
			redImg[0], temp->x, temp->y, 44, 5, ftofix(128), ftofix(scail)); 
		return;
	}
	if( index == -2){	// draw blue goalie
		scail = myCamera->Yscale(goalie[1]->center->y);
		temp = myCamera->WTS(goalie[1]->center);
		pivot_scaled_sprite(myCamera->screen,blueImg[0],
			temp->x, temp->y, 44, 70, itofix(0), ftofix(scail)); 
		return;
	}
	if( index == -1){	// draw ball
		scail = myCamera->Yscale(gState->ball->y);
		temp = myCamera->WTS(gState->ball);
		pivot_scaled_sprite(myCamera->screen,ballImg,
			temp->x, temp->y, 10, 10, itofix(gState->ballRval), ftofix(scail)); 
		return;
	}

}