/****************************Project*******************************
 * This Project is called "Top Down Shooter" for want of a better 
 * name. It will provide a rendering engine for a flying shooter similar
 * to 1984 and the many other top down arcade flying shooters. However
 * key improovements will be implimented to augment game play. First 
 * instead of following a set path and using the controll keys to manuver
 * about the screen, the controll keys will spin the plane on its yaw access
 * and have it accend and decend thus allowing the user greater freedom to
 * explore the world.
 *
 * This Project was Started
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the camera class I provide the key interface between the screen
 * and the world. I contain a pointer to the draw buffer. However I
 * am ment to be passed to individaul classes for their draw function.
 * My key funcitons are screen to world (STW) and world to screen (WTS)
 * I also contain position data for the current camera location and its
 * orientation to the world
 * 
 * This File Was Written:
 * 09/07/06
 * By:
 * Wilson Saunders
 ******************************************************************/
#include <allegro.h>
#include "TdPoint.h"

#ifndef __CAMERA_H__
#define __CAMERA_H__



class Camera {
public:
	BITMAP * screen;
	int xoff,yoff;

	TdPoint * center;
	TdPoint * out;

public:
	Camera();
	~Camera();

	void Init(BITMAP * src);
		// return value is out point
	TdPoint * STW(TdPoint * tgt);	// screen to world conversion fuction
	TdPoint * WTS(TdPoint * tgt);

	double STWx(double Xin);
	double STWy(double Yin);
	double WTSx(double Xin);
	double WTSy(double Yin);

	double Yscale(double Yin);

	bool IsInScreen(TdPoint * tgt);

};

#endif