/*
    
    Copyright (C) 2007  William Quincy 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/    

#ifndef _WORLD_H
#define _WORLD_H 


#include <time.h>       
#include <allegro.h>    
#include <stdio.h>      
#include <math.h>   
#include <string.h>

//Screen res- only tried 640,480
#define SCREENW 640
#define SCREENH 480
#define BPP 16//15, 16, or 32 - not 24 or 8

#ifndef M_PI
  #define M_PI 3.141592653589
#endif

#define MaxGridX 64
#define MaxGridY 64

typedef BITMAP  *Bitmap;             
typedef unsigned char byte; 

typedef struct VECT2d
{
	float 	x,z;
} VECT2d;

//for World class
#define RENDERWIDTH 480// or 640
#if RENDERWIDTH == 480
  #define MAXDEGREES 2880
  #define SWHALF 240
  #define WFUDGE 160
#else
  #define MAXDEGREES 3840
  #define SWHALF 320
  #define WFUDGE 0
#endif
#define HALFCIRCLE (MAXDEGREES / 2)
#define QUARTERCIRCLE (MAXDEGREES / 4)
#define THREEQUARTERCIRCLE (MAXDEGREES - QUARTERCIRCLE)
#define DEGRAD (M_PI / HALFCIRCLE)
#define RADDEG (HALFCIRCLE / M_PI)

#define TILEWIDTH 32
#define TILEHEIGHT 32
#if TILEWIDTH == 32
  #define TILESZSHIFTX 5
  #define TILEMASKX 31 
#elif TILEWIDTH == 16
  #define TILESZSHIFTX 4
  #define TILEMASKX 15 
#elif TILEWIDTH == 64
  #define TILESZSHIFTX 6
  #define TILEMASKX 63   
#endif

#if TILEHEIGHT == 32
  #define TILESZSHIFTY 5
  #define TILEMASKY 31 
#elif TILEHEIGHT == 16
  #define TILESZSHIFTY 4
  #define TILEMASKY 15 
#elif TILEHEIGHT == 64
  #define TILESZSHIFTY 6
  #define TILEMASKY 63   
#endif

#if BPP == 32
   #define SZBITS 4//4 for 32 
   #define BITSHIFT 2
#else
   #define SZBITS 2//2 for 15/16 
   #define BITSHIFT 1
#endif      
#define SHEIGHT SCREENH
#define SWBITD SCREENW*SZBITS//SWIDTH*SZBITS

#define MAXCAMHEIGHT 100

#define TILECAT 1// catapualt: +value sets upward velocity
#define TILESPEED 2// adjust object speed: -value slows: +value speeds
#define TILEANI 4// animated: advance animation frame every x(Value2) game frames(for animated tiles leave Value4 open)
#define TILESOLID 8// collision-able, only collison i'm using s just a solid tile or not a solid tile
struct Tile
{
   float Friction;
   int   Angle;//flow of track: -1 for not track tile.//ok
   signed char Value1;//ok
   signed char Value2;//ok
   signed char Value3;//ok
   signed char Value4;//ok
   byte  Type;//ok
   byte  Frame;//ok
   byte  NumFrames;
   byte  Number;//index into FloorTex bitmap array in world class//ok
};


//for objects 
#define SCALEY 269.0
#define SCALEX 433.0//577.0  : for 640 max render

#define MAXJUMP 69

extern float SinTable[MAXDEGREES];
extern float CosTable[MAXDEGREES];
extern float RCosTable[MAXDEGREES];
extern float RadTable[MAXDEGREES];
extern float ViewHeight[MAXCAMHEIGHT];



void BuildTables(void);

class World
{
private:
    Bitmap *FloorTex; 
    Bitmap Sky;
    Tile grid[MaxGridX][MaxGridY];
    char TexFileNames[100][128];
    char SkyFileName[128];
    int X;
    int FloorTexCount;
    int XOffset;
    int OffFrame;
    int OffNumFrames;
    int OffDelay;
    int OffCount;
    float Gravity;
    

        
public:
    World();
    ~World();
    float GetGravity() {return Gravity;}//*****inline*****//
    void SetGravity(float grav) {Gravity = grav;}//*****inline*****//
    void DrawGround(Bitmap Canvas,float CamX, float CamZ, int CamY, int CamAngle, int hori);
    void DrawSky(Bitmap Canvas,float CamX, float CamZ, int CamY, int CamAngle, int hori);
    void LoadSky(char *FileName);
    Tile GetTile(int x, int y){return grid[x] [y];}//*****inline*****//
    void SetTile(int x, int y, Tile tile){grid[x] [y] = tile;}//*****inline*****//
    Bitmap GetTileBmp(int x, int y){return FloorTex[grid[x] [y].Number];}//*****inline*****//
    Bitmap GetCellBmp(int index){return FloorTex[index];}//*****inline*****//
    int GetNumTiles(void){return FloorTexCount;}//*****inline*****//
    int LoadMap(char *FileName);
    int SaveMap(char *FileName);   
    void NewMap(char *FileName);
    void AnimateTiles();
    void SetOffFrames(int i){OffNumFrames = i;}//*****inline*****//
    void SetOffDelay(int i){OffDelay = i;}//*****inline*****//
    //for editor
    void ZeroFrames(void);
    int GetOffFrames(){return OffNumFrames;}
    int GetOffDelay() {return OffDelay;}
};   

#endif
 
