/*
    
    Copyright (C) 2007  William Quincy 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/    

#include "world.h"

World::World()
{
    int g_x,g_y;
    FloorTex = new Bitmap[0];
    XOffset = WFUDGE;
    X=0;
    OffFrame = 0;
    OffNumFrames = 0;
    OffCount = 0;
    for(g_y=0;g_y<MaxGridY;g_y++)
    {
        for(g_x=0;g_x<MaxGridX;g_x++)
        {
            grid[g_x][g_y].Number = 0;
            grid[g_x][g_y].Type = 0;
            grid[g_x][g_y].Value1 =0;
            grid[g_x][g_y].Value2 = 0;
            grid[g_x][g_y].Value3 = 0;
            grid[g_x][g_y].Value4 = 0;
            grid[g_x][g_y].Frame = 0;
            grid[g_x][g_y].NumFrames = 0;
            
        }
    }
}

World::~World()
{
    destroy_bitmap(Sky); 
    for(int i=0;i<FloorTexCount;i++)
    {
        destroy_bitmap(FloorTex[i]);
    }        
    delete [] FloorTex;
}   

void World::DrawGround(Bitmap Canvas,float CamX, float CamZ, int CamY, int CamAngle, int hori)
{
    float WorldX,WorldZ;
    int x,y;
    int alpha,beta;
    int FloorX,FloorY;
    int g,g_x,g_y;
    int MaskX = TILEMASKX;
    int MaskY = TILEMASKY;
    byte tmpFrame;
    byte *a,*p=Canvas->line[0];
    
    alpha= CamAngle - SWHALF;
    beta= -SWHALF;
    for(x=XOffset;x<XOffset+Canvas->w;x++)
    {
        if(alpha<0){alpha+=MAXDEGREES;}
        if(alpha>=MAXDEGREES){alpha-=MAXDEGREES;}
        if(beta<0){beta+=MAXDEGREES;}
        if(beta>=MAXDEGREES){beta-=MAXDEGREES;}
        
        a=p+(((SCREENW-1-x)+(hori+1)*SCREENW)<<BITSHIFT);
        WorldX=ViewHeight[CamY]*RCosTable[beta]*CosTable[alpha];
        WorldZ=ViewHeight[CamY]*RCosTable[beta]*SinTable[alpha];
        for(y=1;y<Canvas->h-hori-1;y++)
        {
             FloorX=(int)(CamX+WorldX/y);
             FloorY=(int)(CamZ-WorldZ/y);
             g_x = FloorX>>TILESZSHIFTX;
             g_y = FloorY>>TILESZSHIFTY;
             if(g_y<0||g_y>MaxGridY-1 ||g_x<0||g_x>MaxGridX-1)
             {
                 g = 0;
                 tmpFrame = OffFrame;
             }
             else
             {
                 g=grid[g_x][g_y].Number;
                 if(g<0){g=0;}
                 if(g>FloorTexCount){g=FloorTexCount;}
                 tmpFrame = grid[g_x][g_y].Frame;
             }
             memcpy (a,FloorTex[g]->line[0] + ((((FloorY & MaskY)*FloorTex[g]->w)
                    + (FloorX & MaskX)+(tmpFrame<<TILESZSHIFTX))<<BITSHIFT),SZBITS);
             a+=SWBITD;
        }
        alpha++;
        beta++;
    }
}

void World::AnimateTiles()
{
    int x,y;
    if(OffNumFrames == 0)
    {
        OffFrame = 0;
        OffCount = 0;   
    }
    else
    {    
        OffCount++;
        if(OffCount > OffDelay)
        {
            OffFrame++;    
            if(OffFrame > OffNumFrames)
            {
                OffFrame = 0;}
                OffCount = 0;
            
        }        
    }        
    for(y=0;y<MaxGridY;y++)
    {
        for(x=0;x<MaxGridX;x++)
        {
            if(grid[x][y].Type & TILEANI)
            {   
                grid[x][y].Value4++; 
                if(grid[x][y].Value4 > grid[x][y].Value2) 
                {
                    grid[x][y].Frame++;
                    if(grid[x][y].Frame > grid[x][y].NumFrames){grid[x][y].Frame = 0;}
                    grid[x][y].Value4 = 0;
                }    
            }        
        }
    }
}    

void World::ZeroFrames(void)
{
    int x,y;
    OffFrame = 0;
    OffCount = 0;
    for(y=0;y<MaxGridY;y++)
    {
        for(x=0;x<MaxGridX;x++)
        {
            grid[x][y].Frame=0;
            grid[x][y].Value4 = 0;       
        }
    }
}    
    
void World::DrawSky(Bitmap Canvas,float CamX, float CamZ, int CamY, int CamAngle, int hori)
{
    int Offset = MAXDEGREES-CamAngle;
    int Parallax = Sky->w - Offset;
   
    if(Offset > Sky->w)
    {
        Offset = RENDERWIDTH + (MAXDEGREES - Offset);
    }
   
    if(Parallax < Canvas->w)
    {
        blit(Sky,Canvas,Offset,Sky->h-hori-1,0,0,Parallax,hori+1);
        blit(Sky,Canvas,0,Sky->h-hori-1,Parallax,0,Canvas->w-Parallax,hori+1); 
    }
    else
    {
        blit(Sky,Canvas,Offset ,Sky->h-hori-1,0,0,Canvas->w,hori+1);
    }
}     

int World::LoadMap(char *FileName)//TODO: return error
{
    /*File format:
      grid[xx][yy]
      number of texures
     (number of texures)*Filenames
      off map tile animation info:
          OffDelay
          OffNumFrames
          Gravity
      sky filename
    */
    FILE *fp;
    long WorldOffSet;
    int x,y,i,Length;
    char temp[128];
    byte MapVersion;
    
    float ftemp;
    
    fp=fopen(FileName,"r+b");
    
    fread(&MapVersion,sizeof(MapVersion),1,fp);
    //TODO:check map version     
    fread(&WorldOffSet,sizeof(WorldOffSet),1,fp);
    fseek(fp,WorldOffSet,SEEK_SET);
    
    for(y=0;y<MaxGridY;y++)
    {
        for(x=0;x<MaxGridX;x++)
        {
            fread(&grid[x][y].Friction,sizeof(grid[x][y].Friction),1,fp);
            fread(&grid[x][y].Angle,sizeof(grid[x][y].Angle),1,fp);
            fread(&grid[x][y].Value1,sizeof(grid[x][y].Value1),1,fp);
            fread(&grid[x][y].Value2,sizeof(grid[x][y].Value2),1,fp);
            fread(&grid[x][y].Value3,sizeof(grid[x][y].Value3),1,fp);
            fread(&grid[x][y].Value4,sizeof(grid[x][y].Value4),1,fp);
            fread(&grid[x][y].Type,sizeof(grid[x][y].Type),1,fp);
            fread(&grid[x][y].NumFrames,sizeof(grid[x][y].NumFrames),1,fp);
            fread(&grid[x][y].Number,sizeof(grid[x][y].Number),1,fp);
        }
    }
    delete [] FloorTex; 
    fread(&FloorTexCount,sizeof(FloorTexCount),1,fp);
    FloorTex = new Bitmap[FloorTexCount];
    for(i=0;i<FloorTexCount;i++)
    {
        fread(&TexFileNames[i],sizeof(TexFileNames[i]),1,fp);
        FloorTex[i]=load_bitmap(TexFileNames[i],NULL);
        if(!FloorTex[i])
        {    
            FloorTex[i] = create_bitmap(TILEWIDTH,TILEHEIGHT);
            clear_bitmap(FloorTex[i]);  
            textout_centre_ex(FloorTex[i],font,"X X",TILEWIDTH/2,TILEHEIGHT/2,makecol(255,30,30),-1);
            
        }    
    }
    //off map tile animation info
    fread(&OffDelay,sizeof(OffDelay),1,fp);
    fread(&OffNumFrames,sizeof(OffNumFrames),1,fp);
    fread(&Gravity,sizeof(Gravity),1,fp);
    
    fread(&temp,sizeof(SkyFileName),1,fp);
    LoadSky(temp);
    fclose(fp);
    return 0;
}    

int World::SaveMap(char *FileName)
{
    FILE *fp;
    char temp[128];
    char tempTex[64];
    int x,y,i,Length;
    byte MapVersion = 9;
    long WorldOffSet;
    float ftemp;
    
    fp=fopen(FileName,"a+b");
    fread(&MapVersion,sizeof(MapVersion),1,fp);
    fread(&WorldOffSet,sizeof(WorldOffSet),1,fp);
    fseek(fp,WorldOffSet,SEEK_SET);
    for(y=0;y<MaxGridY;y++)
    {
        for(x=0;x<MaxGridX;x++)
        {
            fwrite(&grid[x][y].Friction,sizeof(grid[x][y].Friction),1,fp);
            fwrite(&grid[x][y].Angle,sizeof(grid[x][y].Angle),1,fp);
            fwrite(&grid[x][y].Value1,sizeof(grid[x][y].Value1),1,fp);
            fwrite(&grid[x][y].Value2,sizeof(grid[x][y].Value2),1,fp);
            fwrite(&grid[x][y].Value3,sizeof(grid[x][y].Value3),1,fp);
            fwrite(&grid[x][y].Value4,sizeof(grid[x][y].Value4),1,fp);
            fwrite(&grid[x][y].Type,sizeof(grid[x][y].Type),1,fp);
            fwrite(&grid[x][y].NumFrames,sizeof(grid[x][y].NumFrames),1,fp);
            fwrite(&grid[x][y].Number,sizeof(grid[x][y].Number),1,fp);
        }
    }
    
    fwrite(&FloorTexCount,sizeof(FloorTexCount),1,fp);
    for(i=0;i<FloorTexCount;i++)
    {
        fwrite(&TexFileNames[i],sizeof(TexFileNames[i]),1,fp);
    }
    //off map tile animation info
    fwrite(&OffDelay,sizeof(OffDelay),1,fp);
    fwrite(&OffNumFrames,sizeof(OffNumFrames),1,fp);
    fwrite(&Gravity,sizeof(Gravity),1,fp);
    
    
    fwrite(&SkyFileName,sizeof(SkyFileName),1,fp);
    
    
    fclose(fp);
    return 0;  
}    
void World::NewMap(char *FileName)
{
    FILE *fp;
    int x,y,i;
    char temp[128];
    
    fp=fopen(FileName,"rb");
    for(y=0;y<MaxGridY;y++)
    {
        for(x=0;x<MaxGridX;x++)
        {
            grid[x][y].Number = 1;
            grid[x][y].Type = 0;
            grid[x][y].Value1 =0;
            grid[x][y].Value2 = 0;
            grid[x][y].Value3 = 0;
            grid[x][y].Value4 = 0;
            grid[x][y].Frame = 0;
            
        }
    }
    
    delete [] FloorTex; 
    fscanf(fp,"%i",&FloorTexCount);
    FloorTex = new Bitmap[FloorTexCount];
    for(i=0;i<FloorTexCount;i++)
    {
        fscanf(fp,"%s",TexFileNames[i]);
        FloorTex[i]=load_bitmap(TexFileNames[i],NULL);
        if(!FloorTex[i])
        {    
            FloorTex[i] = create_bitmap(TILEWIDTH,TILEHEIGHT);
            clear_bitmap(FloorTex[i]);  
            textout_centre_ex(FloorTex[i],font,"X X",TILEWIDTH/2,TILEHEIGHT/2,makecol(255,30,30),-1);
            
        }    
    }
    fclose(fp);
    Gravity = 0.5;
    Sky = create_bitmap(2880,101);
    clear_bitmap(Sky);
    
}  

void World::LoadSky(char *FileName)
{
    sprintf(SkyFileName,"%s", FileName);
    destroy_bitmap(Sky);
    Sky = load_bitmap(FileName,NULL);
    if(!Sky)
        {    
            Sky = create_bitmap(2880,101);
            clear_bitmap(Sky);  
            textout_centre_ex(Sky,font,"X X",10,10,makecol(255,30,30),-1);
            
        }    
      
}  

void BuildTables()
{
    int j;   
    float radians;   
    for(j=0;j<MAXDEGREES;j++)
    {
        radians=j*DEGRAD;
        SinTable[j]=sin(radians);
        CosTable[j]=cos(radians);
        RCosTable[j]=1000.0/cos(radians);
        RadTable[j]=radians;
        
    }
    for(j=0;j<MAXCAMHEIGHT;j++)
    {
       ViewHeight[j]=j*.271828282828283;
    }   
}   


