/*
    
    Copyright (C) 2007  William Quincy 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/    

#include "main.h"

void gtimer()
{
    gcounter++;
}
END_OF_FUNCTION(gtimer);



void GameLoop()
{
  World theWorld1;
   int angle = 0;
   int y = 14; 
   int GameOver = 0;
   int i;
   float x = 480;
   float z = 480;
   float dx,dy;
        
   Bitmap Pl1Canvas;
   Pl1Canvas = create_sub_bitmap(Backbuffer,10,8,480,180);
   
   blit(Board,Backbuffer,0,0,0,0,SCREENW,SCREENH);
   
   theWorld1.LoadMap("data\\test.brd");
   
   do
   {
      while(gcounter)
      {
          
        if(key[KEY_RIGHT]!=0)
        {
          angle-=18;
          if(angle<0){angle+=MAXDEGREES;}
          if(angle>=MAXDEGREES){angle-=MAXDEGREES;}
        }
          
       if(key[KEY_LEFT]!=0)
       {
          angle+=18;
          if(angle<0){angle+=MAXDEGREES;}
          if(angle>=MAXDEGREES){angle-=MAXDEGREES;}
       }
       
        if(key[KEY_UP]!=0)
        {
           dy=-7*SinTable[angle];
           dx=7*CosTable[angle];
           x+=dx;
           z+=dy;
           if(x+dx > 3045 ){x=-3045;}
           if(z+dy > 3045 ){z=-3045;}
           if(x+dx < -3045 ){x=3045;}
           if(z+dy < -3045 ){z=3045;}
          
        }    
        if(key[KEY_F12]!=0)
        {
            save_bmp("Screen.bmp",Backbuffer,NULL);
        }    
        
        theWorld1.AnimateTiles();
        gcounter--;
       }
        
        theWorld1.DrawSky(Pl1Canvas,x,z,y,angle, HORIZION);
        theWorld1.DrawGround(Pl1Canvas,x,z,y,angle, HORIZION);
         
        //vsync();
        blit(Backbuffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
        if(key[KEY_ESC]!=0){GameOver=1;}
        
    }while(GameOver==0);
    destroy_bitmap(Pl1Canvas);
    
   
}    


void Init()
{
    
    int Card = GFX_AUTODETECT_FULLSCREEN;//GFX_DIRECTX_SAFE;//GFX_DIRECTX_SOFT;//GFX_AUTODETECT_WINDOWED;//
    allegro_init();
    #if BPP == 32
    set_color_depth(32);
    if (set_gfx_mode(Card, SCREENW, SCREENH, 0, 0) < 0) 
    {
      #ifdef LOGGING
          MessageOut("log.txt","Error setting GFX mode.");
      #endif 
      exit(0);
    }    
    #else
    set_color_depth(16);
    if (set_gfx_mode(Card, SCREENW, SCREENH, 0, 0) < 0) 
    {
        set_color_depth(15);
        if (set_gfx_mode(Card, SCREENW, SCREENH, 0, 0) < 0) 
        {
            #ifdef LOGGING
               MessageOut("log.txt","Error setting GFX mode.");
            #endif 
            exit(0);
        }
    }    
    #endif
    set_color_conversion(COLORCONV_TOTAL);                                                
    
                                                                                         
    Backbuffer=create_bitmap(SCREEN_W,SCREEN_H);
    Board = load_bitmap("data\\board.bmp",NULL);
    clear(Backbuffer);
    install_keyboard();
    install_mouse();
    install_timer();
    
    LOCK_FUNCTION(gtimer);
    LOCK_VARIABLE(gcounter);
    install_int_ex(gtimer,BPS_TO_TIMER(33));
    BuildTables();
    
}



void ShutDown()
{
   destroy_bitmap(Backbuffer);
   destroy_bitmap(Board);
   

}

int main()
{
    
    Init();
    GameLoop();
    ShutDown();
    return(0);
}
END_OF_MAIN();
