/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__UTILS__
#define EME__UTILS__
/*----------------------------------------------------------------------------
  Various utilities

  - Version
  - Memory error
  - Casts
  - Allegero GUI messages
  - String length and unicode
  - Popups -- questions
  - Popups -- messages
----------------------------------------------------------------------------*/


#include "debug.h"

#include "ustring.h"
#include "translat.h"


/* Version
   ---------------------------------*/
#define EME_CURRENT_VERSION   ((EME_VERSION_MAJOR<<16) + (EME_VERSION_MINOR))
//#define EME_VERSION_TEXT      EME_VERSION_STR
#define EME_COPYRIGHT         "(C) 2002 Annie Testes"
#define EME_INFO \
  "eme comes with ABSOLUTELY NO WARRANTY.\n" \
  "This is free software, and you are welcome to\n" \
  "redistribute it under certain conditions.\n" \
  "Please refer to the accompanying file copying.txt for details."



/* Memory error
   ---------------------------------*/
#include <allegro.h>

#ifdef DEBUG
#define ERROR_QUIT(n) ::abort()
#else
#define ERROR_QUIT(n) ::exit(n)
#endif

#define ERROR_NOMEM() do {                                \
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0),                   \
    allegro_message(                                      \
      UString("Error (%s %d): out of memory\n").string(), \
      UString(__FILE__).string(), __LINE__                \
    ),                                                    \
    ERROR_QUIT(1);                                        \
  } while(0)


#define CHECK_POINTER(p) if (!p) ERROR_NOMEM()



/* Casts
   ---------------------------------*/
#ifdef DEBUG
#define DYNAMIC_CAST(type, object) dynamic_cast<type>(object)
#else
#define DYNAMIC_CAST(type, object) (type)(object)
#endif
#define CAST_TO_VOID_PTR(object) ((void*)(object))
#define CAST_FROM_VOID_PTR(type, object) ((type)(object))



/* Allegero GUI messages
   ---------------------------------*/
#define MSG_APPLY     (MSG_USER+0)



/* String length and unicode
   ---------------------------------*/
/* Number of characters for a string that represent an integer */
#define STRING_INT_LENGTH 32

/* Base length for a path. If it appears that it is not enough, multiply the
   length by 2 until it is enough */
#define STRING_PATH_BASE_LENGTH 256



/* Popups -- questions
   ---------------------------------*/
#define OVERWRITE_FILE(file) \
  (alert(Translation("File exists"), file, Translation("Overwrite ?"), Translation("Yes"), Translation("No"), 0, 0)==1)

#define REALLY_QUIT() \
  (alert(0, Translation("Really quit ?"), 0, Translation("Yes"), Translation("No"), 0, 0)==1)



/* Popups -- messages
   ---------------------------------*/
#define MESSAGE(msg) \
  alert(0, msg, 0, Translation("OK"), 0, 0, 0)

#define NOT_YET_DONE_STR Translation("Not yet done !")
#define NOT_YET_DONE() MESSAGE(NOT_YET_DONE_STR)

#define NO_MAP_LOADED_STR Translation("No map !")
#define NO_MAP_LOADED() //MESSAGE(NO_MAP_LOADED_STR)

#define ALREADY_EXISTS_STR Translation("File already exists")
#define ALREADY_EXISTS(file) \
  alert(ALREADY_EXISTS_STR, file, 0, Translation("OK"), 0, 0, 0)

#define DOESNT_EXIST_STR Translation("File doesn't exist")
#define DOESNT_EXIST(file) \
  alert(DOESNT_EXIST_STR, file, 0, Translation("OK"), 0, 0, 0)

#define ERROR_READING_STR Translation("Error while reading")
#define ERROR_READING(file, err_str) \
  alert(ERROR_READING_STR, file, err_str, Translation("OK"), 0, 0, 0)

#define ERROR_WRITING_STR Translation("Error while writing")
#define ERROR_WRITING(file, err_str) \
  alert(ERROR_WRITING_STR, file, err_str, Translation("OK"), 0, 0, 0)

#define ERROR_CREATING_STR Translation("Error while creating map")
#define ERROR_CREATING(err_str) \
  alert(ERROR_CREATING_STR, err_str, 0, Translation("OK"), 0, 0, 0)

#define ERROR_BAD_UNDO_LEVEL_STR \
  Translation("Maximum undo level must be strictly positive")
#define ERROR_BAD_UNDO_LEVEL() MESSAGE(ERROR_BAD_UNDO_LEVEL_STR)



/* Menory allocation helpers
   ---------------------------------*/
#ifdef __cplusplus
#include <stdlib.h>
template <typename T> void Malloc(T *&ptr, size_t nelt)
{
  ptr = static_cast<T*>(malloc(nelt*sizeof(T)));
  DBG_ASSERT(ptr);
}

template <typename T> void Calloc(T *&ptr, size_t nelt)
{
  ptr = static_cast<T*>(calloc(nelt, sizeof(T)));
  DBG_ASSERT(ptr);
}

template <typename T> bool Realloc(T *&ptr, size_t nelt)
{
  T *ret = static_cast<T*>(realloc(ptr, nelt*sizeof(T)));
  DBG_ASSERT(ret);
  if (ret) ptr = ret;
  return ret;
}

template <typename T> void Free(T *&ptr)
{
  free(ptr);
  ptr = 0;
}
#endif /* __cplusplus */


#endif /* EME__UTILS__ */

