/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TILES_STACK__
#define EME__TILES_STACK__

#include "utils.h"

class Tiles;
#include "tiles.h"
class BaseProperty;
#include "config.inc"
#include <vector>

class TilesStack {
public:
  TilesStack();
  ~TilesStack();

  TilesStack *clone() const { return new TilesStack(*this); }

  int begin() const { return 0; }
  int end() const { return layers_.size(); }
  int depth() const { return layers_.size(); }

#if 0
  /* May be re-try one day */
  int begini() const { ((TilesStack*)this)->update(); return size_.begini(); }
  int beginj() const { ((TilesStack*)this)->update(); return size_.beginj(); }
  int endi() const { ((TilesStack*)this)->update(); return size_.endi(); }
  int endj() const { ((TilesStack*)this)->update(); return size_.endj(); }
  int width() const { ((TilesStack*)this)->update(); return size_.width(); }
  int height() const { ((TilesStack*)this)->update(); return size_.height(); }
  bool is_in(int i, int j) const { ((TilesStack*)this)->update(); return size_.is_in(i, j); }
  bool is_in(int l) const { ((TilesStack*)this)->update(); return l>=begin() && l<end(); }
#else
  int begini() const { return size_.begini(); }
  int beginj() const { return size_.beginj(); }
  int endi() const { return size_.endi(); }
  int endj() const { return size_.endj(); }
  int width() const { return size_.width(); }
  int height() const { return size_.height(); }
  bool is_in(int i, int j) const { return size_.is_in(i, j); }
  bool is_in(int l) const { return l>=begin() && l<end(); }
#endif

private:
  Tiles *get_(int l) const
    { return is_in(l) ? layers_[l] : 0; }

public:
  /* Returns the layer at l */
  const Tiles *get(int l) const { return get_(l); }
  Tiles *get(int l) { return get_(l); }
  template <typename T> const T *get(int l) const
    { return DYNAMIC_CAST(const T*, get_(l)); }

  /* Set the layer at l to t.
   * Takes ownership of t */
  void set(int l, Tiles *t);

  /* Set the layer at l to 0,
   * doesn't delete the layer */
  void clear(int l);

  /* Removes the layer at l, moving down the next layers,
   * doesn't delete the layer */
  void remove(int l);

  /* Insert the layer t at l, moving up the next layers.
   * Takes ownership of t */
  void insert(int l, Tiles *t);

  /* Should be called whenever a layer changes size */
  void update();

private:
  TilesStack(const TilesStack &other);

  typedef std::vector<Tiles*> Imp;
  Imp layers_;
  Size size_;
};

#endif /* EME__TILES_STACK__ */

