/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__TEXT__
#define EME__TEXT__

#ifdef __cplusplus
extern "C" {
#endif


/*
 * COMMAND:
 *  An array of commands define the parser rules.  The array should be
 *  terminated by a command with a NULL keyword.
 *  All the strings should be in U_CURRENT.
 *  The first command should be the begin command, the second should be
 *  the end command, the last should be a catch all command (for example:
 *  { "", first_char_of_all_commands, 0, 0, 0, 0, 0 } ).
 *  The text of the first command will be the id of the text.
 *  It seems that when two commands are too much alike (eg \name and \n) the
 *  parser ends in an infinite loop.
 *  If a command is unrecognized (for example due to a typo) the parser ends in
 *  an infinite loop.
 * Notes:
 *  In the text, several spaces, \t and \n in a row are replaced by one space.
 */
typedef struct COMMAND {
  const char *keyword;
  const char *end;
  const char *replace;
  const char *prepend;
  const char *append;
  const char *overline;
  const char *underline;
} COMMAND;


typedef struct TEXT {
  char *id;
  char *text;
} TEXT;


TEXT *load_texts(const char *fname, COMMAND *commands);
void unload_texts(TEXT *texts);
const char *find_text(TEXT *texts, const char *id);

#ifdef __cplusplus
}
#endif

#endif /* EME__TEXT__ */

