/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__OPTIONS__SET_THEME__
#define EME__OPTIONS__SET_THEME__
/*----------------------------------------------------------------------------
  Functions for choosing the theme
----------------------------------------------------------------------------*/


#include "debug.h"


struct MENU;

typedef enum {
  DEFAULT_THEME,
  PAPER_THEME,
  THREED_THEME,
  ROUND_THEME,
  NUM_THEMES
} THEME_ID;

MENU *theme_menu(void);

void SetTheme(const char *theme_name);
const char *GetThemeName(void);
const char *GetDefaultThemeName(void);


#endif /* EME__OPTIONS__SET_THEME__ */

