/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "selected.h"

#include "debug.h"
#include "utils.h"


SelectedTiles::SelectedTiles(void): tiles_()
{
}


SelectedTiles::SelectedTiles(const SelectedTiles *sel): tiles_(sel->tiles_)
{
}


SelectedTiles::~SelectedTiles(void)
{
}


SelectedTiles *SelectedTiles::Clone(void) const
{
  SelectedTiles *tmp = new SelectedTiles(this);
  return tmp;
}


void SelectedTiles::Remove(const SelectedTiles *to_remove)
{
  for (const_iterator id=to_remove->Begin(); id!=to_remove->End(); ++id) {
    if (IsIn(to_remove->GetX(id), to_remove->GetY(id))) {
      Remove(to_remove->GetX(id), to_remove->GetY(id));
    }
  }
}


