/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__PROPERTY__
#define EME__PROPERTY__
/*----------------------------------------------------------------------------
  A property, abstract class

  A property is a value for a tile in a layer.

- Constructor/destructor
- Accessors
- Using the property value
----------------------------------------------------------------------------*/

#include "debug.h"
#include "pooluser.h"

class Entry;
struct BITMAP;

#ifdef DEBUG
#  define DBG_PROP_TYPE char *dbg_type;
#  define DBG_SET_PROP_TYPE(name) dbg_type=name
#else
#  define DBG_PROP_TYPE
#  define DBG_SET_PROP_TYPE(name)
#endif

#define NUM_POOLS 8

class BaseProperty MEMORY_POOL_CLASS(NUM_POOLS) {

public:
  DBG_PROP_TYPE

  /* Constructor/destructor
     ---------------------------------*/
  BaseProperty (void);
  virtual ~BaseProperty (void);
  virtual BaseProperty *Clone (void) const = 0;


  /* Accessors
     ---------------------------------*/
  /* Derived classes should define functions Set and Get to set and get the
     value */


  /* Using the property value
     ---------------------------------*/
  /* Sets the property value from the given one */
  virtual void CopyFrom(const BaseProperty *p) = 0;

  /* Returns true if the property value is equal to the given one.
     This function can assume 'IsSameType' has returned true */
  virtual int IsEqualTo(const BaseProperty *p) const = 0;

private:
  BaseProperty(const BaseProperty&);
  BaseProperty &operator=(const BaseProperty&);
};

#endif /* EME__PROPERTY__ */

