/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__MENU_DIALOG__
#define EME__MENU_DIALOG__
/*----------------------------------------------------------------------------
  Menu dialog
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"

#define NUM_MENU_DIALOGS 1

#define NUM_USER_MENUS 42

struct MENU;
class Map;
class Brush;

int popup_help (void);

class MenuDialog: public Dialog {

public:
  MenuDialog (int x, int y, int w, int h, DIALOG *d);
  MenuDialog (DIALOG *d);
  ~MenuDialog (void);

  void LazyInit(void);

  void DrawGrid(int yesno);

  void SetUserMenuTitle(const char *title);
  /* 'name' = 0 to remove the menu */
  void SetUserMenu(
    int menu_index, const char *name, void (*cb)(Map*),
    int hotkey=0
  );
  void CallUserMenu(int menu_index);

  /* returns false if the key wasn't used,
     returns true if the key was used and a user cb was called
   */
  bool HotKey(int key);

  void SetLoadBrush(Brush *(*load_brush)(const char *));
  void SetSaveBrush(bool (*save_brush)(const char *, const Brush *));

  void AllowMap(bool yesno, unsigned int features);
  void AllowEdit(bool yesno, unsigned int features);
  void AllowSelect(bool yesno, unsigned int features);
  void AllowBrush(bool yesno, unsigned int features);
  void AllowUser(bool yesno, unsigned int features);

protected:
  void Init (DIALOG *d);

private:
  MenuDialog(const MenuDialog&);
  MenuDialog &operator=(const MenuDialog&);

  DIALOG *dialog;
  MENU *menus;
  void (*user_cb[NUM_USER_MENUS])(Map*);
  int user_hotkeys[NUM_USER_MENUS];
};

#endif /* EME__MENU_DIALOG__ */

