/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__LAYER_DIALOG__
#define EME__LAYER_DIALOG__
/*----------------------------------------------------------------------------
  Dialog for selecting the viewed layers
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"
class ViewedLayers;

#define NUM_LAYER_DIALOGS 6 // Box, list, 4 buttons

class LayerDialog: public Dialog {

public:
  LayerDialog(int x, int y, int w, int h, DIALOG *d);
  LayerDialog(DIALOG *d);
  ~LayerDialog(void);

  void InitMap(void);

  void LazyInit(void);

  void Redraw(void) const;

  void SetActiveLayer(int n);
  void SetViewedLayers();

  const ViewedLayers *GetViewedLayers() { return viewed_layers_; }

  void Allow(bool yesno, unsigned int feature);

protected:
  void Init(DIALOG *d);

  const char *HelpText() const;

private:
  LayerDialog(const LayerDialog&);
  LayerDialog &operator=(const LayerDialog&);

  typedef enum {
    BUTTON_ADD = 2,
    BUTTON_DEL,
    BUTTON_UP,
    BUTTON_DOWN,
    BUTTON_COUNT
  } BUTTON;

  DIALOG *box_;
  DIALOG *list_;
  ViewedLayers *viewed_layers_;

  static int LayerListProc(int msg, DIALOG *d, int c);
  static const char *LayerNameCb(int index, int *list_size, DIALOG *d);
};

#endif /* EME__LAYER_DIALOG__ */

