/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__ENTRY__
#define EME__ENTRY__
/*----------------------------------------------------------------------------
  A variable dialog, i.e. can change its type dynamically

  An Entry uses NUM_ENTRY_DIALODS DIALOS structures
  One DIALOG displays the property name, the other one is for entering the
property value.

  Functions used by *Creator classes should be: SetState and Get*State. You
should be able to use them as you use a "normal" Allegro DIALOG.
----------------------------------------------------------------------------*/

#include "debug.h"

#define NUM_ENTRY_DIALOGS 2

struct DIALOG;
class Translation;
class UString;

class Entry {

public:
  Entry(DIALOG *d, const char *help_id=0);
  ~Entry(void);

  void ShowName(bool yesno);

  /* Sets the internal DIALOG values, these values have the same meaning than
     the ones in a "normal" Allegro DIALOG */
  void SetState(
    const char *name,              /* Name to display */
    int (*proc)(int,DIALOG*,int),  /* DIALOG 'proc' field */
    int d1,                        /* DIALOG internal values */
    int d2,
    void *dp,
    void *dp2,
    void *dp3,
    int flags
  );
  void SetFlagsState(int flags);

  /* Set the entry to a do nothing DIALOG */
  void SetDefaultState(void);

  /* Returns the current values of the DIALOG */
  int GetD1State(void) const;
  int GetD2State(void) const;
  void *GetDPState(void) const;
  void *GetDP2State(void) const;
  void *GetDP3State(void) const;
  int GetFlagsState(void) const;

  /* Clears the DIALOG's background */
  void Clear(void);

  /* Redraws the DIALOG on the screen */
  void Redraw(void);

  /* Sets the DIALOG size */
  void SetSize(int x, int y, int w, int h);

protected:

private:
  Entry(const Entry&);
  Entry &operator=(const Entry&);

  int Proc(int msg, DIALOG *d, int c);

  DIALOG *dialogs_;
  int (*proc_)(int, DIALOG*, int);
  const char *help_id_;
  bool show_name_;

  static int edit_proc(int, DIALOG*, int);
};

#endif /* EME__ENTRY__ */

