/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__PERCENT_TYPE__
#define EME__PERCENT_TYPE__
/*----------------------------------------------------------------------------
  Percent Property

  - Types
  - Casts
  - Creator
  - Private
----------------------------------------------------------------------------*/

#include "debug.h"
#include "utils.h"

#include "creator.h"
#include "prop.h"
#include "cnumber.h"

#include "template.h"

class Entry;


struct Percent {
  /* Types
     ---------------------------------*/
  class Creator;
  typedef Number::Property Property;
  typedef int Base;
  typedef int Param;


#ifdef EME__COMPATIBILITY
  /* Casts
     ---------------------------------*/
  static inline Property *Cast(BaseProperty *p)
    { return DYNAMIC_CAST(Property*, p); }
  static inline const Property *Cast(const BaseProperty *p)
    { return DYNAMIC_CAST(const Property*, p); }

  static inline Creator *Cast(BaseCreator *c)
    { return DYNAMIC_CAST(Creator*, c); }
  static inline const Creator *Cast(const BaseCreator *c)
    { return DYNAMIC_CAST(const Creator*, c); }
#endif


  /* Creator
     ---------------------------------*/
  friend class Creator: public BaseCreator {

  public:
    /* Constructor/destructor
       --------------------*/
    Creator(StaticString *name, int max, int v);
    Creator *Clone(void) const;
    ~Creator(void);

    /* Properties
       --------------------*/
    Property *Create(int value) const
      { return new Property(value); }

    virtual void Draw(
      const BaseProperty *p, BITMAP *bmp, int x, int y, int w, int h,
      float scale, int l, int i, int j
    ) const;
    virtual int PrintValue(
      const BaseProperty *p, BITMAP *bmp, int x, int y, int color
    ) const;

    /* Entry handlers
       --------------------*/
    void UpdateEntry(Entry *e, const BaseProperty *p) const;
    void UpdateProperty(BaseProperty *p, const Entry *e) const;

  protected:
    Creator(StaticString *name, int max, BaseProperty *p):
      BaseCreator(name, p), max_(max)
      {DBG_SET_CREATOR_TYPE("Percent");}
    Creator(const Creator *other):
      BaseCreator(other), max_(other->max_)
      {DBG_SET_CREATOR_TYPE("Percent");}

  private:
    Creator(const Creator&);
    Creator &operator=(const Creator&);

    inline const Property *ReferenceProperty(void) const
      { return ::Cast<Percent>(GetReference()); }
    inline Property *ReferenceProperty(void)
      { return ::Cast<Percent>(GetVariableReference()); }

    int max_; /* */
  }; /* class Percent::Creator */


  /* Private
     ---------------------------------*/
private:
}; /* struct Percent */

#ifdef DEBUG
typedef Percent::Property PercentProperty;
typedef Percent::Creator PercentCreator;
#endif

#endif /* EME__PERCENT_TYPE__ */

