/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cmdgroup.h"

#include "command.h"

#include "debug.h"
#include "utils.h"

#include <stdlib.h>


CommandGroup::CommandGroup(void): Command(), commands_count(0), commands(0), first_time(true)
{
}


CommandGroup::~CommandGroup(void)
{
  for(int i=0; i<commands_count; i++) {
    delete commands[i];
  }
  Free(commands);
}


void CommandGroup::UnExecute(void)
{
  /* Undoing must be in the reverse order */
  for(int i=commands_count-1; i>=0; i--) {
    commands[i]->UnExecute();
  }
}


void CommandGroup::Execute(void)
{
  LOG("CommandGroup::Execute\n");
  if (!first_time) {
    for(int i=0; i<commands_count; i++) {
      commands[i]->Execute();
    }
  }
  first_time = false;
}


int CommandGroup::IsEmpty(void) const
{
  for(int i=0; i<commands_count; i++) {
    if(!commands[i]->IsEmpty()) {
      return 0;
    }
  }
  return 1;
}


void CommandGroup::Add(Command *cmd)
{
  Realloc(commands, commands_count+1);
  commands[commands_count] = cmd;
  commands_count++;
  if (!cmd->IsEmpty()) {
    cmd->Execute();
  }
}


