/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__COMMAND_CUT__
#define EME__COMMAND_CUT__
/*----------------------------------------------------------------------------
  Cut command:

  cuts a group of tiles from the current layer.
----------------------------------------------------------------------------*/

#include "debug.h"

#include "command.h"

class SelectedTiles;
class SparseTiles;
class Tiles;
class Map;

class CommandCut: public Command {

public:
  CommandCut(Map *map, int l, const SelectedTiles *tiles);
  ~CommandCut(void);

  void Execute(void);
  void UnExecute(void);

  int IsEmpty(void) const;

protected:

private:
  CommandCut(const CommandCut&);
  CommandCut &operator=(const CommandCut&);

  SelectedTiles *selection_; /* Indices of the tiles to cut */
  SparseTiles *saved_tiles_; /* Tiles that have been cut */
  Tiles *layer_;             /* Layer on which it is done */
};

#endif /* EME__COMMAND_CUT__ */

