/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "cmdbrush.h"

#include "debug.h"

#include "cmdgroup.h"
#include "cmdpaste.h"

#include "brush.h"
#include "tstack.h"
#include "tiles.h"
#include "stiles.h"
#include "map.h"


CommandPasteBrush::CommandPasteBrush(Map *map, const Brush *to_paste, int x, int y)
{
  for (int l=0; l<to_paste->GetNumLayers(); ++l) {
    const SparseTiles *tiles = to_paste->GetLayer(l);
    if (tiles && map->GetLayer(l)) {
      Command *cmd = new CommandPaste(
        map, l, tiles, x+tiles->begini(), y+tiles->beginj()
      );
      Add(cmd);
    }
  }
}


CommandPasteBrush::~CommandPasteBrush(void)
{
}

