/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__STATIC_STRING__
#define EME__STATIC_STRING__
/*----------------------------------------------------------------------------
  Reference counted constant string

Usage:
  StaticString *str = new StaticString("Hello");
  str->Hold();
  ...
  printf("String is %s\n", str->string());
  ...
  str->Release();
You must not access a StaticString after having released it.
You must always create StaticString via 'new' (be very carefull with
temporarly objects).
A StaticString can contain only U_CURRENT encoded strings.
----------------------------------------------------------------------------*/


#include "debug.h"
#include "utils.h"
#include <allegro.h>

class StaticString {
public:
  explicit StaticString(const char *str): refcount_(0), string_(ustrdup(str))
    {}

  void Hold(void)
    {refcount_++;}

  void Release(void)
    {DBG_ASSERT(refcount_>0); refcount_--; if(refcount_==0) delete this;}

  const char *string(void) const
    {DBG_ASSERT(refcount_>0); return string_;}

  int IsEqual(const StaticString *str)
    {DBG_ASSERT(refcount_>0); return str==this||ustrcmp(str->string(), string())==0;}

protected:
  ~StaticString(void)
    {DBG_ASSERT(refcount_==0); free(string_);}

  /* Forbid default functions created by the compiler */
  StaticString(const StaticString&);
  StaticString& operator=(const StaticString&);

private:
  int refcount_;
  char *string_;
};

#endif /* EME__STATIC_STRING__ */

