/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__PROPERTY_DIALOG__
#define EME__PROPERTY_DIALOG__
/*----------------------------------------------------------------------------
  Dialog for modifying map properties
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"
#include "entry.h" /* for NUM_ENTRY_DIALOGS */

typedef enum {
  PROPERTY_DIALOG_BOX = 0,
  PROPERTY_DIALOG_PROP,
  PROPERTY_DIALOG_ENTRY,
  NUM_PROPERTY_DIALOGS = PROPERTY_DIALOG_ENTRY+NUM_ENTRY_DIALOGS
} PROPERTY_DIALOG;

class Entry;

class PropertyDialog: public Dialog {

public:
  PropertyDialog (int x, int y, int w, int h, DIALOG *d);
  PropertyDialog (DIALOG *d);
  ~PropertyDialog (void);

  void InitMap (void);

  void LazyInit(void);

  void SetActiveProperty (int new_prop);

  Entry *GetEntry() const;

protected:
  void Init (DIALOG *d);

  const char *HelpText() const;

private:
  PropertyDialog(const PropertyDialog&);
  PropertyDialog &operator=(const PropertyDialog&);

  DIALOG *box;      /* Background box */
  DIALOG *prop;     /* List of properties */
  DIALOG *entry;    /* Property entry */
  Entry *map_entry;

  static int PropListProc (int msg, DIALOG *d, int c);
  static const char *PropListCb (int index, int *list_size, DIALOG *d);
};

#endif /* EME__PROPERTY_DIALOG__ */

