/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__POOL__H__
#define EME__POOL__H__
/*----------------------------------------------------------------------------
  Memory pool

  Memory management for numerous objects with the same size
----------------------------------------------------------------------------*/


#include "debug.h"

#include <stddef.h>

class MemoryPool {
public:
  MemoryPool(size_t base_size, size_t nobjects = 512);
  ~MemoryPool(void);

  void *Alloc(size_t size);
  void Free(void *dead_object, size_t size);

private:
  MemoryPool(const MemoryPool&);
  MemoryPool &operator=(const MemoryPool&);

  void* &Next(void *chunk, int i=0)
    { return *((void**) ( ((char*)chunk) + (i*actual_base_size) )); }
  size_t base_size;
  size_t actual_base_size;
  size_t nobjects;

  void *head_of_free_list;
  int num_used;
};

#endif /* EME__POOL__H__ */

