/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__PLACE__
#define EME__PLACE__

#include "config.inc"
#include <utility>

typedef struct std::pair<int, int> Place;

/* i and j are swapped so the places are sorted horizontally then vertically
   instead of the other way */
inline Place MakePlace(int i, int j)
  { return Place(j, i); }

inline int PlaceI(const Place &p)
  { return p.second; }

inline int PlaceJ(const Place &p)
  { return p.first; }

#endif /* EME__PLACE__ */

