/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__LINE_DIALOG__
#define EME__LINE_DIALOG__
/*----------------------------------------------------------------------------
  Help line dialog
----------------------------------------------------------------------------*/

#include "debug.h"

#include "dialog.h"


#define NUM_LINE_DIALOGS 1


class LineDialog: public Dialog {

public:
  LineDialog(int x, int y, int w, int h, DIALOG *d);
  LineDialog(DIALOG *d);
  ~LineDialog();

private:
  LineDialog(const LineDialog&);
  LineDialog &operator=(const LineDialog&);

  void Init(DIALOG *d);
  void InitMap();

  const char *GetHelp() const;

  void Idle();
  void Draw();

  DIALOG *box_;
  const char *help_;
  bool map_is_modified_;
  int mouse_tile_x_;
  int mouse_tile_y_;
  float scale_;
  int map_width_;
  int map_height_;

  static int LineProc(int msg, DIALOG *d, int c);
};


#endif /* EME__LINE_DIALOG__ */

