/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__FULL_TILES__
#define EME__FULL_TILES__

class BaseProperty;
class BaseCreator;

#include "tiles.h"


class FullTiles: public Tiles {
public:
  FullTiles(BaseCreator *c, int i, int j, int w, int h);
  FullTiles(BaseCreator *c);
  ~FullTiles();

  FullTiles *clone() const;

  FullTiles &operator=(const FullTiles &other);

  int count() const { return width()*height(); }

  void clear(int i, int j);

  typedef BaseProperty*** Imp;

protected:
  BaseProperty *get_(int i, int j) const;
  void set_(int i, int j, BaseProperty *p);
  void copy_(int i, int j, const BaseProperty *p);

  void move_(int di, int dj);
  void insert_col_(int i, int count);
  void remove_col_(int i, int count);
  void insert_row_(int j, int count);
  void remove_row_(int j, int count);

private:
  FullTiles(const FullTiles &other);

  Imp tiles_;
  BaseProperty *default_value_; /* Property used to fill new tiles */

#ifdef EME__COMPATIBILITY
  /* Compatibility with FullLayer */
  FullTiles *Clone() const { return clone(); }
#endif
};


#endif /* EME__FULL_TILES__ */

