/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__POPUPS__
#define EME__POPUPS__
/*----------------------------------------------------------------------------
  Popup helpers specific to eme
----------------------------------------------------------------------------*/


#include "debug.h"

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/


/* popup_quit:
 *  Displays messages with buttons "Quit" and "Continue", if quit is clicked,
 *  exits (calls DBG_ASSERT(0), if DEBUG defined), else (or if ESC is pressed)
 *  returns.  You should use it only in special conditions (i.e. to continue
 *  the program may crash it)
 */
void popup_quit(const char *msg1, const char *msg2, const char *msg3);


/* popup_size:
 *  Popups two windows to choose the map size
 *
 *  The user entered size is put in 'width' and 'height'.
 *
 *  Returns FALSE if one of the popup is cancelled or TRUE if they are OK'ed.
 */
int popup_size(
  const char *width_title, int *width, const char *height_title, int *height
);

int popup_size_and_pos(
  const char *title, int *x, int *y, int *w, int *h,
  const char **list, int *item
);

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif /* EME__POPUPS__ */

