/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__DIALOG__
#define EME__DIALOG__
/*----------------------------------------------------------------------------
  A group of related DIALOGs, abstract class

- Constructor/destructor
- Initialization
- Map related functions
- Initialization (protected)
- Internal data
----------------------------------------------------------------------------*/

#include "debug.h"

struct DIALOG;
class Map;


#define SINGLE_HEIGHT ((5*text_height(font))/2)
#define DIALOG_PADDING 4
#define SB_SIZE (altheme_scrollbar_width)


class Dialog {

public:
  /* Constructor/Destructor
     ---------------------------------*/
  Dialog(
    int x, int y,            /* Dialog position on the screen (in pixels) */
    int w, int h,            /* Dialog size (in pixels) */
    DIALOG *d                /* Array of dialogs */
  );

  Dialog(
    DIALOG *d                /* Array of dialogs */
  );

  virtual ~Dialog(void);


  /* Initialization
     ---------------------------------*/
  void SetSize( /* Sets the size and position of the dialog */
    int x, int y,            /* Dialog position on the screen (in pixels) */
    int w, int h,            /* Dialog size (in pixels) */
    DIALOG *d = 0            /* Array of dialogs, if 0 use the private one */
  );

  /* Initialize what cannot be initialized before allegro_init, for example
     translations */
  virtual void LazyInit(void);


  /* Map related functions
     ---------------------------------*/
  void SetMap( /* Sets the map to work on */
    Map *m                   /* Map to work on */
  );

  Map *GetMap(void) const; /* Returns the map worked on */


  const char *Help(int mx, int my) const;


protected:
  virtual void InitMap(void); /* Map related init specific to children */
  virtual const char *HelpText() const;


private:
  Dialog(const Dialog&);
  Dialog &operator=(const Dialog&);

  Map *map_;                 /* Map to work on */
  DIALOG *dialog_;
};

#endif /* EME__DIALOG__ */

