/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__COMMAND_PASTE__
#define EME__COMMAND_PASTE__
/*----------------------------------------------------------------------------
  Paste command:

  paste a group of tiles in the current layer
----------------------------------------------------------------------------*/

#include "debug.h"

#include "command.h"

class SparseTiles;
class Tiles;
class SelectedTiles;
class Map;

class CommandPaste: public Command {

public:
  CommandPaste(Map *map, int l, const SparseTiles *to_paste, int x, int y);
  ~CommandPaste(void);

  void Execute(void);
  void UnExecute(void);

  int IsEmpty(void) const;

protected:

private:
  CommandPaste(const CommandPaste&);
  CommandPaste &operator=(const CommandPaste&);

  SparseTiles *tiles;              /* Tiles to paste */
  SparseTiles *saved_tiles;        /* Replaced tiles */
  SelectedTiles *saved_empty_tiles;/* Indices of the tiles that has appeared */
  Tiles *layer;                    /* Layer on which it is done */
  int x, y;                        /* Top left corner where tiles are pasted */
};

#endif /* EME__COMMAND_PASTE__ */

