/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__BRUSH_LIST__
#define EME__BRUSH_LIST__
/*----------------------------------------------------------------------------
  Class that handles the brushes the user can use
----------------------------------------------------------------------------*/

#include "debug.h"


class Brush;

class BrushList {

public:
  BrushList(void);
  ~BrushList(void);

  /* 'brush' ownership is taken, 'name' ownership is not taken */
  void AddBrush(Brush *brush, const char *name);
  void DeleteBrush(int b);

  /* Deletes all brushes */
  void Clear(void);

  int GetNumBrushes(void) const;
  Brush *GetBrush(int b) const;
  const char *GetBrushName(int b) const;

  int GetActive(void) const
    {return active_brush;}
  void SetActive(int n)
    {active_brush = n;}

  int Popup(void);

protected:

private:
  BrushList(const BrushList&);
  BrushList &operator=(const BrushList&);

  int num_brushes;
  Brush **brushes;
  char **names;
  int active_brush;
};

#endif /* EME__BRUSH_LIST__ */

