/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef EME__ALLEGRO_CLEAN__
#define EME__ALLEGRO_CLEAN__
/*----------------------------------------------------------------------------
  Helpers for Allegro

  These functions make sure the returned value is not trucated. All of them
  returns a char * allocated with malloc
----------------------------------------------------------------------------*/


#include "debug.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SIZEOF_CHARACTER 6

#define uatoi(s) ustrtol(s, 0, 10)


char *al_clean_fix_filename_path(const char *path);
char *al_clean_get_executable_name(void);

char *al_clean_get_full_executable_name(void);

char *al_clean_uconvert_dup(const char *str, int format, int new_format);

#define uconvert_dup al_clean_uconvert_dup

#ifdef __cplusplus
}
#endif

#endif /* EME__ALLEGRO_CLEAN__ */

