/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__VERSION__
#define SEME__VERSION__

#include "debug.h"


/* Version: (major<<16) + minor */
/* Previous versions */
/* Before version 0.2, the tile loading/saving loop was:
   for (int i=0; i<width; ++i) for (int j=0; j<height; ++j)
   which was slow in eme. Now it is:
   for (int j=0; j<height; ++j) for (int i=0; i<width; ++i)
   And NOW (eme version 0.2) it is irrelevant :(
 */
#define SEME_WITH_FORTRAN_LOOP  ((0<<16) + (2))

/* Current version */
#define SEME_CURRENT_VERSION  ((SEME_VERSION_MAJOR<<16) + (SEME_VERSION_MINOR))
#define SEME_VERSION_TEXT     SEME_VERSION_STR

#define SEME_MAJIK            (('S'<<24)+('E'<<16)+('M'<<8)+('E'))

#define SEME_BRUSH_MAJIK      (('B'<<24)+('E'<<16)+('M'<<8)+('E'))

#endif /* SEME__VERSION__ */

