/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__NEW__MAP__
#define SEME__NEW__MAP__

#include "debug.h"

#include "help.h"

#if 0
#define PROP_LIST_HELP \
  TITLE("Map properties") \
  PARAG("To add a new property, click on the \"add\" Button.") \
  PARAG("To remove a property, click on its name, then on the \"Remove\" " \
     " button.") \
  PARAG("To edit a property, double-click on its name.")

#define LAYER_LIST_HELP \
  TITLE("Layers") \
  PARAG("To add a new layer, click on the \"Add\" button.") \
  PARAG("To remove a layer, click on its name, then on the \"Remove\" " \
     " button.") \
  PARAG("To edit a layer, double-click on its name.")

#define TILE_BUTTON_HELP \
  TITLE("Map and tiles shape") \
  PARAG("Click here to edit the map and tiles shape and related informations.")

#define COMPRESS_HELP \
  TITLE("Compression") \
  PARAG("Tick this if you want to compress your maps.")

  
#define PROP_NAME_HELP \
  TITLE("Map property name") \
  PARAG("Type in the map property name.  Note:") \
  PARAG("- TAB and # are not allowed (if you enter them, they will be " \
      "replaced by a space),") \
  PARAG("- if you save C code, the map property name may be changed to " \
      "become a valid C identifier.")

#define PROP_TYPE_HELP \
  TITLE("Map property type") \
  PARAG("Choose the map property type, by selecting a list item.")

#define PROP_DATA_HELP \
  TITLE("Additional data for map property") \
  PARAG("Click here to enter additional data for the map property.  " \
      "The data depends on the type of the property.")


#define LAYER_NAME_HELP \
  TITLE("Layer name") \
  PARAG("Type in the layer name.  Note:") \
  PARAG("- TAB and # are not allowed (if you enter them, they will be " \
      "replaced by a space),") \
  PARAG("- if you save C code, the layer name may be changed to " \
      "become a valid C identifier.")

#define LAYER_FULLNESS_HELP \
  TITLE("Layer fullness") \
  PARAG("Choose a full layer if all the tiles in the layer must have " \
      "a value.  Choose a sparse layer if there will be holes in the layer.  " \
      "This feature is not yet implemented in seme.")

#define LAYER_TYPE_HELP \
  TITLE("Layer type") \
  PARAG("Choose the layer type, by selecting a list item.")

#define LAYER_DATA_HELP \
  TITLE("Additional data for layer") \
  PARAG("Click here to enter additional data for the layer.  " \
      "The data depends on the type of the layer.")


#define MAP_SHAPE_HELP \
  TITLE("Map shape") \
  PARAG("Choose the overall shape of the map.  Usually, top-down maps are " \
      "rectangular and isometric ones have a diamond shape.")

#define TILE_SHAPE_HELP \
  TITLE("Tiles shape") \
  PARAG("Select the tiles shape.")

#define TILE_SIZE_HELP \
  TITLE("Tiles size") \
  PARAG("Enter the typical tile size (in pixels).")

#define TILE_ODDNESS_HELP \
  TITLE("Tile oddness") \
  PARAG("Enter the way you want the odd rows to be shifted.") \
  PARAG("For typical maps (if tile and map shape are the same), " \
      "rows need not be shifted (tick \"none\").  " \
      "For other cases, see the documentation: " \
      "\"Chapter 7: seme - 2.2 Specifying a map format - Tiles\".")

#define TILE_OFFSET_HELP \
  TITLE("Tiles offset") \
  PARAG("Enter the horizontal and vertical pixels distance between two tiles") \
  PARAG("For typical maps (if oddness is none), " \
      "the offsets should be equal to the tile size.  " \
      "For other cases, see the documentation: " \
      "\"Chapter 7: seme - 2.2 Specifying a map format - Tiles\".")
#else

#define PROP_LIST_HELP "SemePropList"

#define LAYER_LIST_HELP "SemeLayerList"

#define TILE_BUTTON_HELP "SemeTileButton"

#define COMPRESS_HELP "SemeCompress"
  
#define PROP_NAME_HELP "SemePropName"

#define PROP_TYPE_HELP "SemePropType"

#define PROP_DATA_HELP "SemePropData"

#define LAYER_NAME_HELP "SemeLayerName"

#define LAYER_FULLNESS_HELP "SemeLayerFullness"

#define LAYER_TYPE_HELP "SemeLayerType"

#define LAYER_DATA_HELP "SemeLayerData"

#define MAP_SHAPE_HELP "SemeMapShape"

#define TILE_SHAPE_HELP "SemeTileShape"

#define TILE_SIZE_HELP "SemeTileSize"

#define TILE_ODDNESS_HELP "SemeTileOddness"

#define TILE_OFFSET_HELP "SemeTileOffset"

#endif

class SemeMap;

extern SemeMap *seme_map; // FIXME


int current_prop_index();
int current_layer_index();

SemeMap *seme_popup_edit(SemeMap *previous);

#endif /* SEME__NEW__MAP__ */

