/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__PROPERTY__MANAGER__
#define SEME__PROPERTY__MANAGER__

#include "debug.h"

class SemeProperty;

class SemePropertyManager {

public:
  static int Count(void);

  static const char *GetName(int index);
  static const char *GetAsciiName(int index);
  static int GetIndex(const char *name);

  static SemeProperty *Create(int index);
  static SemeProperty *Create(const char *name);

  static int AskAdditionalData(int index, const SemeProperty *p=0);
  static int AskAdditionalData(const char *name, const SemeProperty *p=0);

  static SemeProperty *Get(int index);
  static SemeProperty *Get(const char *name);

  static int Register(const char *name, SemeProperty *(*creator)(void));

  static int IsValid(int index);

private:
  SemePropertyManager(const SemePropertyManager&);
  SemePropertyManager &operator=(const SemePropertyManager&);
  SemePropertyManager(void);
  ~SemePropertyManager(void);

  static int count;
  static const char **names;
  static const char **ascii_names;
  static SemeProperty *(**creators)(void);
  static SemeProperty **props;
};

#endif /* SEME__PROPERTY__MANAGER__ */

