/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__PROPERTY__DATAFILE__
#define SEME__PROPERTY__DATAFILE__
/*------------------------------------------------------------------------------
  SemeDatafile property

- Constructor/destructor
- Additional data
- Loading/saving format file
- Creating/loading/saving map
- Saving C code
- Internal functions and data
------------------------------------------------------------------------------*/

#include "debug.h"

#include "semeprop.h"

#define SEME_DEFAULT_DATA 0


class SemeDatafile: public SemeProperty {

public:
  SEME_GET_TYPE

  /* Constructor/destructor
     ---------------------------------*/
  static SemeProperty *Create(void);

  SemeDatafile(void);
  ~SemeDatafile(void);

  void SubCopyFrom(const SemeProperty *p);


  /* Additional data
     ---------------------------------*/
  int AskAdditionalData(void);
  const char *GetDataDescription(void);


  /* Loading/saving format file
     ---------------------------------*/
  int LoadFormat(FILE *f, int num_indent);
  int SaveFormat(FILE *f, int num_indent) const;


  /* Creating/loading/saving map
     ---------------------------------*/
  BaseCreator *CreateCreator(void);

  BaseCreator *LoadProperty(PACKFILE *pf, int version);

  BaseProperty *LoadTile(PACKFILE *pf, int version, const BaseCreator *creator) const;

  int Save(PACKFILE *f, int version, const BaseProperty *p) const;


  /* Saving C code
     ---------------------------------*/
  int SaveCStructField(FILE *f, int num_indent) const;
  int SaveCCode(
    FILE *f, int num_indent, const char *leading, const char *cleaning
  ) const;
  int SaveCCleanCode(FILE *f, int num_indent, const char *leading) const;


protected:
  /* Internal functions and data
     ---------------------------------*/
  SEME_TYPE

  int ComputeNumObjs(void);
  const char *AdditionalData(void);

  static inline const SemeDatafile *cast(const SemeProperty *p)
    { return dynamic_cast<const SemeDatafile*>(p); }
  static inline SemeDatafile *cast(SemeProperty *p)
    { return dynamic_cast<SemeDatafile*>(p); }

private:
  SemeDatafile(const SemeDatafile&);
  SemeDatafile &operator=(const SemeDatafile&);

  char *fname;
  char *ascii_fname;
  int num_objs;
};

#endif /* SEME__PROPERTY__DATAFILE__ */

