/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__PROPERTY__COLOR__
#define SEME__PROPERTY__COLOR__
/*------------------------------------------------------------------------------
  SemeColor property

- Constructor/destructor
- Additional data
- Loading/saving format file
- Creating/loading/saving map
- Saving C code
- Internal functions and data
------------------------------------------------------------------------------*/

#include "debug.h"

#include "semeprop.h"

#define SEME_DEFAULT_COLOR 0


class SemeColor: public SemeProperty {

public:
  SEME_GET_TYPE

  /* Constructor/destructor
     ---------------------------------*/
  static SemeProperty *Create(void);

  SemeColor(void);
  ~SemeColor(void);

  void SubCopyFrom(const SemeProperty *p);


  /* Additional data -- none
     ---------------------------------*/


  /* Load/Save format file
     ---------------------------------*/
  int LoadFormat(FILE *f, int num_indent);
  int SaveFormat(FILE *f, int num_indent) const;


  /* Creating/loading/saving map
     ---------------------------------*/
  BaseCreator *CreateCreator(void);

  BaseCreator *LoadProperty(PACKFILE *pf, int version);

  BaseProperty *LoadTile(PACKFILE *pf, int version, const BaseCreator *creator) const;

  int Save(PACKFILE *pf, int version, const BaseProperty *p) const;


  /* Saving C code
     ---------------------------------*/
  int SaveCStructField(FILE *f, int num_indent) const;
  int SaveCCode(
    FILE *f, int num_indent, const char *leading, const char *cleaning
  ) const;
  int SaveCCleanCode(FILE *f, int num_indent, const char *leading) const;


protected:
  /* Internal functions and data
     ---------------------------------*/
  SEME_TYPE

private:
  SemeColor(const SemeColor&);
  SemeColor &operator=(const SemeColor&);
};

#endif /* SEME__PROPERTY__COLOR__ */

