/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semeaddp.h"

#include "semedlg.h"

#include "translat.h"
#include "alclean.h"

#include <stdlib.h>
#include <allegro.h>

#include "semenew.h"
#include "sememap.h"
#include "semeprop.h"



/*------------------------------------------------------------------------------
  Add Prop Dialog
------------------------------------------------------------------------------*/

/* Indices to the dialog array 'get_prop_dialog()' */
typedef enum {
  ADD_PROP_BOX,
  ADD_PROP_TITLE,

  /* The map property name */
  ADD_PROP_TEXT1,
  ADD_PROP_NAME,   /* d->dp: map property name */

  /* The map property type */
  ADD_PROP_TEXT2,
  ADD_PROP_TYPE,   /* d->d1: index of the map property type */

  /* The map property additional data */
  ADD_PROP_BUTTON,
  ADD_PROP_DATA,   /* d->dp: string to display the additional data */

  ADD_PROP_OK,
  ADD_PROP_CANCEL,
  NUM_ADD_PROP_DIALOGS
} ADD_PROP_DIALOG;

#define NAME_LEN 256
static char name_str[(NAME_LEN+1)*SIZEOF_CHARACTER] = EMPTY_STRING;

static const Translation i18nProperty("Map property");
static const Translation i18nName("Name");
static const Translation i18nType("Type");
static const Translation i18nData("Data");
static const Translation i18nOK("OK");
static const Translation i18nCancel("Cancel");


DIALOG *get_prop_dialog()
{
  static DIALOG dlg[NUM_ADD_PROP_DIALOGS+1];
  static bool initialized = false;
  if (!initialized) {
    int i=0;

    box(dlg[i++],     0, 0, 320, 200);
    title(dlg[i++], 160, 8, 160, 20, i18nProperty);

    text(dlg[i++],  8, 38,  60, 20, PROP_NAME_HELP, i18nName);
    edit(dlg[i++], 68, 38, 244, 20, PROP_NAME_HELP, name_str, NAME_LEN);

    text(dlg[i++],      8, 56,  60, 20, PROP_TYPE_HELP, i18nType);
    proplist(dlg[i++], 68, 56, 244, 80, PROP_TYPE_HELP);

    databutton(dlg[i++], 8, 144,  54, 20, PROP_DATA_HELP, i18nData);
    datatext(dlg[i++],  68, 144, 244, 20, PROP_DATA_HELP);

    button(dlg[i++],   8, 172, 80, 20, '\r', D_EXIT, i18nOK);
    button(dlg[i++], 232, 172, 80, 20,    0, D_EXIT, i18nCancel);

    end(dlg[i]);

    initialized = true;
  }
  return dlg;
}


/* popup_add_prop:
 * popups a dialog for editing a map property
 */
const SemeProperty *popup_add_prop(SemeProperty *p)
{
  if(p) {
    ustrzcpy(
      get_prop_name(), NAME_LEN*SIZEOF_CHARACTER,
      p->GetName()->string()
    );
    get_prop_dialog()[ADD_PROP_TYPE].d1 = p->GetType();
    SemePropertyManager::Get(get_prop_type())->CopyFrom(p);
  }
  set_dialog_color(get_prop_dialog(), gui_fg_color, gui_bg_color);
  centre_dialog(get_prop_dialog());
  int ret = popup_dialog(get_prop_dialog(), -1);
  if(ret == ADD_PROP_OK) {
    SemeProperty *pp = SemePropertyManager::Get(get_prop_type());
    pp->SetName(get_prop_name());
    return SemePropertyManager::Get(get_prop_type());
  }
  else {
    return 0;
  }
}


char *get_prop_name()
{
  return (char*)get_prop_dialog()[ADD_PROP_NAME].dp;
}

int get_prop_type()
{
  return get_prop_dialog()[ADD_PROP_TYPE].d1;
}

