#ifndef LOADER_LOADER_H
#define LOADER_LOADER_H

#ifdef __cplusplus
extern "C" {
#endif


#define LOADER_SEME_CONST const

#define LOADER_SEME_MAJIK 1397050693
#define LOADER_SEME_VERSION 2
#define LOADER_SEME_WITH_FORTRAN_LOOP 2


typedef struct LOADER_TILE {
   int Ground; /* Datafile object */
   int Bottom_left; /* Datafile object */
   int Bottom_right; /* Datafile object */
   int Top_left; /* Datafile object */
   int Top_right; /* Datafile object */
} LOADER_TILE;

typedef struct LOADER_MAP {
   int width, height;
   char *Name; /* String */
   LOADER_TILE **tiles;
} LOADER_MAP;



/* loader_load_map:
 *  Load the map file 'fname'
 *  Returns NULL if an error occurred
 */
LOADER_MAP *loader_load_map(LOADER_SEME_CONST char *fname);

/* loader_destroy_map:
 *  Destroys a map created by 'loader_load_map'
 */
void loader_destroy_map(LOADER_MAP *map);

#ifdef __cplusplus
}
#endif


#endif /* LOADER_LOADER_H */
