################################
### System guessing
################################

# NOTE:  This makefile should have NO target, because it's usually included
#        early in the main makefile

# This file is included in various makefiles, it should work on its own and set
# the three following variables. 
# DOS_SHELL: should be set to 1 if the shell is DOS,
#  and should be undefined if the shell is an Unix one
# SYSTEM: Currently there are ``unix'' for various Unices (tested under Linux)
#  and ``djgpp''.  (these systems are defined because Allegro libs and includes
#  aren't specified the same way in both cases)
# EXE: extension for the executable,
#  should be set to ``.exe'' under MS systems

# Quoting make info page: "Avoid trouble on system where the SHELL variable
# might be inherited from the environment."  If I understand correctly GNU make
# behavior, SHELL will be equal to the environment variable if make wasn't able
# to find a Unix shell under DOS.
SHELL = /bin/sh
# I'm not sure SHELL is always in CAPS
ifeq '$(findstring COMMAND.COM,$(SHELL))' 'COMMAND.COM'
  DOS_SHELL=1
endif
ifeq '$(findstring CMD.EXE,$(SHELL))' 'CMD.EXE'
  DOS_SHELL=1
endif
ifeq '$(findstring 4DOS.COM,$(SHELL))' '4DOS.COM'
  DOS_SHELL=1
endif


# Try to guess system
# TODO: add other systems 
ifndef SYSTEM
  #ifneq (,$(findstring linux,$(OSTYPE)))
  ifeq '$(findstring linux,$(OSTYPE))' 'linux'
    SYSTEM=unix
  else
    ifdef DJDIR
      SYSTEM=djgpp
    endif
  endif
endif


ifeq '$(SYSTEM)' 'djgpp'
  EXE=.exe
endif
ifdef DOS_SHELL
  EXE=.exe
endif

