################################
### emetool building
################################

# There are two version because of different echo behavior and no sh shell
# under DOS

ifdef DOS_SHELL
###
### Version for systems without sh
###
### Uses: echo (DOS behavior), type (instead of cat), del (instead of rm), gcc
.PHONY: emetool

emetool: emetool$(EXE)

emetool$(EXE): emetool.c
	gcc -Wall -g -o $@ $<
	-del emetool.c

emetool.c: emetool.dos
	@del $@
	@echo // Autogenerated: do not hand edit >> $@
	@echo // >> $@
	@echo #define EME_DIR "$(CURDIR)" >> $@
	@echo #define EME_VERSION "$(EME_VERSION_STR)" >> $@
	@echo #define EXE "$(EXE)" >> $@
	@echo #define MAKE "$(MAKE)" >> $@
	@echo #define CC "$(CC)" >> $@
	@echo #define VERSION_FLAGS "$(VERSION_FLAGS) " >> $@
	@echo #define MY_FLAGS "$(MY_FLAGS) " >> $@
	@echo #define OTHER_FLAGS "$(CFLAGS) " >> $@
	@echo #define DIR_FLAGS "-I$(CURDIR)/src " >> $@
	@echo #define CFLAGS VERSION_FLAGS MY_FLAGS OTHER_FLAGS DIR_FLAGS >> $@
	@echo #define MY_LIBS "$(CURDIR)/lib/libeme.a " >> $@
	@echo #define OTHER_LIBS "$(LIBS) " >> $@
	@echo #define LIBS MY_LIBS OTHER_LIBS >> $@
	@echo #define REMOVE "$(RM)" >> $@
	@echo // >> $@
	@echo #define SYSTEM "$(SYSTEM)" >> $@
	@echo #define DEFAULT_COMPATIBILITY "$(DEFAULT_COMPATIBILITY)" >> $@
	@echo #define COMPATIBILITY "$(COMPATIBILITY)" >> $@
	@echo #define DEFAULT_DEBUG "$(DEFAULT_DEBUG)" >> $@
	@echo #define DEBUG "$(DEBUG)" >> $@
	@echo #define DEFAULT_PROFILE "$(DEFAULT_PROFILE)" >> $@
	@echo #define PROFILE "$(PROFILE)" >> $@
	@echo #define DEFAULT_UNICODE "$(DEFAULT_UNICODE)" >> $@
	@echo #define UNICODE "$(UNICODE)" >> $@
	@echo #define DEFAULT_MEMORY_POOL "$(DEFAULT_MEMORY_POOL)" >> $@
	@echo #define MEMORY_POOL "$(MEMORY_POOL)" >> $@
	@echo #define OVERRIDE_LIBS "$(OVERRIDE_LIBS)" >> $@
	@echo #define OVERRIDE_INCLUDES "$(OVERRIDE_INCLUDES)" >> $@
	@echo #define TEST_FLAGS "$(TESTFLAGS)" >> $@
	type $< >> $@

else
###
### Verions for real operating systems
###
### Uses: sh, echo (GNU behavior), cat, chmod
emetool: emetool.nix
	@echo "#!/bin/sh" > $@
	@echo "# Autogenerated: do not hand edit" >> $@
	@echo "" >> $@
	@echo "eme_dir=\"$(CURDIR)\"" >> $@
	@echo "eme_version=\"$(EME_VERSION_STR)\"" >> $@
	@echo "exe=\"$(EXE)\"" >> $@
	@echo "make=\"$(MAKE)\"" >> $@
	@echo "cc=\"$(CC)\"" >> $@
	@echo "cflags=\"$(ALL_CFLAGS) -I$(CURDIR)/src\"" >> $@
	@echo "libs=\"$(CURDIR)/lib/libeme.a $(LIBS)\"" >> $@
	@echo "remove=\"$(RM)\"" >> $@
	@echo "" >> $@
	@echo "system=\"$(SYSTEM)\"" >> $@
	@echo "default_compatibility=\"$(DEFAULT_COMPATIBILITY)\"" >> $@
	@echo "compatibility=\"$(COMPATIBILITY)\"" >> $@
	@echo "default_debug=\"$(DEFAULT_DEBUG)\"" >> $@
	@echo "debug=\"$(DEBUG)\"" >> $@
	@echo "default_profile=\"$(DEFAULT_PROFILE)\"" >> $@
	@echo "profile=\"$(PROFILE)\"" >> $@
	@echo "default_unicode=\"$(DEFAULT_UNICODE)\"" >> $@
	@echo "unicode=\"$(UNICODE)\"" >> $@
	@echo "default_memory_pool=\"$(DEFAULT_MEMORY_POOL)\"" >> $@
	@echo "memory_pool=\"$(MEMORY_POOL)\"" >> $@
	@echo "override_libs=\"$(OVERRIDE_LIBS)\"" >> $@
	@echo "override_includes=\"$(OVERRIDE_INCLUDES)\"" >> $@
	@echo "test_flags=\"$(TESTFLAGS)\"" >> $@
	cat emetool.nix >> $@
	@chmod ugo+x $@

endif

# vim: syntax=make noet
