#ifndef WARP_H
#define WARP_H

#include "modules/animate.h"
#include "modules/collide.h"

#define VG_MAX_WARPS 32

#define WARP_TYPE_DOOR      1
#define WARP_TYPE_PIPE_DOWN 2
#define WARP_TYPE_PIPE_UP   3
#define WARP_TYPE_PIPE_LR   4

typedef struct
{
	
	int x, y;
	int dx, dy, ds;
	ANIMATION * ap;
	COLLISION_MAP cmap;
	int active;
	int type;
	
	/* the script */
	char script[4096];
	
} VG_WARP;

void warp_execute(VG_WARP * wp);

#endif
