#ifndef SPRITE_H
#define SPRITE_H

#include "modules/animate.h"
#include "modules/collide.h"

#define VG_SPRITE_MAX_STATES  16
#define VG_MAX_SPRITE_DATA   128

#define VG_SPRITE_PLAYER       0
#define VG_SPRITE_GOOMBA       1
#define VG_SPRITE_DEATH        2
#define VG_SPRITE_TURTLE       3
#define VG_SPRITE_THWOMP       4
#define VG_SPRITE_BULLETGUN    5
#define VG_SPRITE_BULLET       6
#define VG_SPRITE_BEETLE       7
#define VG_SPRITE_FLAME_PIVOT  8
#define VG_SPRITE_FLAME        9
#define VG_SPRITE_PARATURTLE  10
#define VG_SPRITE_REDTURTLE   11
#define VG_SPRITE_COIN        12
#define VG_SPRITE_RTURTLE     13
#define VG_SPRITE_MARIO       14

typedef struct
{
	
	ANIMATION * ap[VG_SPRITE_MAX_STATES];
	int cx[VG_SPRITE_MAX_STATES];
	int cy[VG_SPRITE_MAX_STATES];
	int cw[VG_SPRITE_MAX_STATES];
	int ch[VG_SPRITE_MAX_STATES];
	
} VG_SPRITE_DATA;

typedef struct
{
	
	VG_SPRITE_DATA * sp;
	COLLISION_MAP cmap[VG_SPRITE_MAX_STATES];
	
	fixed x, y, z;
	fixed vx, vy, vz;
	fixed angle;
	
	int state, frame, type, active, id, timer, d1, d2, life;
	char death;
	
} VG_SPRITE;

VG_SPRITE_DATA * vg_sprite_load_fp(PACKFILE * fp);
VG_SPRITE_DATA * vg_sprite_load(char * fn);
int vg_sprite_save_fp(VG_SPRITE_DATA * sp, PACKFILE * fp);
int vg_sprite_save(VG_SPRITE_DATA * sp, char * fn);
void vg_sprite_destroy(VG_SPRITE_DATA * sp);
VG_SPRITE_DATA * vg_sprite_create(void);

#endif
