#ifndef PLAYER_H
#define PLAYER_H

#include <allegro.h>
#include "modules/animate.h"
#include "modules/collide.h"
#include "modules/tilemap.h"
#include "control.h"
#include "level.h"

#define PLAYER_STATES 32

typedef struct
{
	
	/* animation data */
	ANIMATION * ap[PLAYER_STATES]; /* player animations */
	
    /* positioning tables */
	int cx_table[PLAYER_STATES], cy_table[PLAYER_STATES], cw_table[PLAYER_STATES], ch_table[PLAYER_STATES];
	int px_table[PLAYER_STATES], py_table[PLAYER_STATES];
	int gx_table[PLAYER_STATES], gy_table[PLAYER_STATES];
	int mix, miy, mir; /* center of character */
	int ix, iy; /* location of pointer relative to character */
	int pf;

} CHARACTER;

typedef struct
{

	CHARACTER character;
	
	/* player data */
    int color;
    int reload_time, reload_fast;

    COLLISION_MAP cmap[PLAYER_STATES];
    PLAYER_CONTROLLER controller;

    fixed fx, fy, vx, vy, evx, evy, mx, gy;
    int x, y, cx, cy, tx, ty;
    int state, frame, ground;
    int flash_time;
    int active, tele_in, tele_out, tele_state, tele_frame;

    /* other stuff */
    int score, hits, shots;
    int cloak_time;
    int moon_time;
    int run_time;
    int deflect_time;
    int fly_time;
    int turbo_time;
    int weapon;
    int ammo;
    int target;
    int it, flag, time, shock_time, loose, item, gem[5], gems, just;
    int remote;
    int col;
    int slip;
//    int data;
    char name[224];
	
	int entered;
	int char_pick;
	unsigned long char_sum;
	int data_pick;

} PLAYER;

void player_logic(PLAYER * pp);
void player_render(BITMAP * bp, PLAYER * pp);

#endif
