#include "../data.h"
#include "../game.h"
#include "turtle.h"

void vg_object_turtle_logic(VG_SPRITE * sp)
{
	int i;
	
	if(sp->state == 0 || sp->state == 1)
	{
		if(vg_sprite_near(sp, 320))
		{
			sp->x += sp->vx;
			update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			if(tilemap_collide(vg_level->tilemap, &sp->cmap[sp->state]))
			{
				sp->vx = -sp->vx;
				sp->x = itofix(get_sprite_x(&sp->cmap[sp->state], 16));
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			}
			if(!tilemap_rubb_check(vg_level->tilemap, vg_level->tilemap->il, TILEMAP_FLAG_SOLIDT, &sp->cmap[sp->state]))
			{
				sp->vy += ftofix(VG_CHARACTER_GRAVITY);
				if(sp->vy > itofix(5))
				{
					sp->vy = itofix(5);
				}
				sp->y += sp->vy;
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
				if(tilemap_collide(vg_level->tilemap, &sp->cmap[sp->state]))
				{
					sp->y = itofix(get_sprite_y(&sp->cmap[sp->state], 16));
					update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
					sp->vy = itofix(0);
				}
			}
			for(i = 0; i < VG_MAX_OBJECTS; i++)
			{
				if(vg_sprite[i].active && i != sp->id && !vg_sprite[i].death && collide(&sp->cmap[sp->state], &vg_sprite[i].cmap[vg_sprite[i].state]))
				{
					switch(vg_sprite[i].type)
					{
						case VG_SPRITE_GOOMBA:
						case VG_SPRITE_TURTLE:
						{
							sp->vx = -sp->vx;
							if(sp->vx < itofix(0))
							{
								sp->state = 0;
							}
							else
							{
								sp->state = 1;
							}
							vg_sprite[i].vx = -vg_sprite[i].vx;
							break;
						}
					}
				}
			}
			sp->frame++;
		}
	}
	else
	{
		sp->x += sp->vx;
		sp->y += sp->vy;
		sp->vy += ftofix(0.5);
		sp->angle += fmul(itofix(6), sp->vx);
		if(fixtoi(sp->y) - vg_level->tilemap->y > 240)
		{
			sp->active = 0;
		}
	}
}

void vg_object_turtle_hit(VG_SPRITE * sp)
{
	if(vg_player.sprite.state != VG_CHARACTER_HIT_LEFT && vg_player.sprite.state != VG_CHARACTER_HIT_RIGHT)
	{
		if(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].rx + vg_player.sprite.cmap[0].top.point[0].x < fixtoi(sp->x) + sp->cmap[0].rx + sp->cmap[0].top.point[0].x)
		{
			vg_player_set_state(VG_CHARACTER_HIT_RIGHT);
			vg_player.sprite.timer = 0;
			vg_player.sprite.vx = itofix(-5);
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
		else
		{
			vg_player_set_state(VG_CHARACTER_HIT_LEFT);
			vg_player.sprite.timer = 0;
			vg_player.sprite.vx = itofix(5);
			if(vg_character_take_hit(&vg_player, 50))
			{
				ncds_play_sample(vg_sound[VG_SOUND_PLAYER_DIE], 127, -1, -1);
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
	}
}
