#include "../data.h"
#include "../game.h"
#include "goomba.h"

void vg_object_thwomp_logic(VG_SPRITE * sp)
{
	int i;
	
	switch(sp->state)
	{
		
		/* waiting to drop */
		case 0:
		{
			if(vg_sprite_near(sp, 32))
			{
				sp->state = 1;
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			}
			break;
		}
		
		/* dropping */
		case 1:
		{
			sp->vy += ftofix(VG_CHARACTER_GRAVITY);
			if(sp->vy > itofix(5))
			{
				sp->vy = itofix(5);
			}
			sp->y += sp->vy;
			update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
			if(tilemap_collide(vg_level->tilemap, &sp->cmap[sp->state]))
			{
				sp->y = itofix(get_sprite_y(&sp->cmap[sp->state], 16));
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
				sp->vy = itofix(0);
				sp->state = 2;
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
				sp->timer = 0;
			}
			break;
		}
		case 2:
		{
			sp->timer++;
			if(sp->timer > 60)
			{
				sp->y -= itofix(1);
				update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
				if(tilemap_collide(vg_level->tilemap, &sp->cmap[sp->state]))
				{
					sp->y = itofix(get_sprite_y(&sp->cmap[sp->state], 16));
					update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
					sp->vy = itofix(0);
					sp->state = 0;
					update_collision_map(&sp->cmap[sp->state], fixtoi(sp->x), fixtoi(sp->y));
					sp->timer = 0;
				}
			}
			break;
		}
	}
}

void vg_object_thwomp_hit(VG_SPRITE * sp)
{
	if(vg_player.sprite.state != VG_CHARACTER_HIT_LEFT && vg_player.sprite.state != VG_CHARACTER_HIT_RIGHT)
	{
		if(fixtoi(vg_player.sprite.x) + vg_player.sprite.cmap[0].rx + vg_player.sprite.cmap[0].top.point[0].x < fixtoi(sp->x) + sp->cmap[0].rx + sp->cmap[0].top.point[0].x)
		{
			vg_player_set_state(VG_CHARACTER_HIT_RIGHT);
			vg_player.sprite.vx = itofix(-4);
			if(vg_character_take_hit(&vg_player, 50))
			{
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
		else
		{
			vg_player_set_state(VG_CHARACTER_HIT_LEFT);
			vg_player.sprite.vx = itofix(4);
			if(vg_character_take_hit(&vg_player, 50))
			{
				if(vg_player.lives > 0)
				{
					vg_game_restart_level();
				}
				else
				{
					ncds_stop_music();
					fade_out(4);
					vg_state = VG_STATE_TITLE;
					vg_logic();
					vg_update();
					vg_draw();
					fade_in(vg_palette, 4);
					ncds_play_music("title.xm", 1);
					gametime_reset();
				}
			}
		}
	}
}
